GO
IF NOT EXISTS(SELECT * FROM sys.columns
WHERE Name = N'BookingManagerActive' AND OBJECT_ID = OBJECT_ID(N'[Reservations]'))
BEGIN
	ALTER TABLE [dbo].[Reservations] ADD [BookingManagerActive] INT not null default 1
END 
GO
IF NOT EXISTS(SELECT * FROM sys.columns
WHERE Name = N'BookingManagerTime' AND OBJECT_ID = OBJECT_ID(N'[Reservations]'))
BEGIN
	ALTER TABLE [dbo].[Reservations] ADD [BookingManagerTime] DATETIME not null default GETUTCDATE()
END 
GO
---------------------------------------table BookingManagerMessage------------------------------------
if not exists (select * from sysobjects where name='BookingManagerMessage' and xtype='U')
begin
    CREATE TABLE BookingManagerMessage
	(
	Id INT NOT NULL IDENTITY(1,1) CONSTRAINT pk_BookingManagerMessage_mid PRIMARY KEY,
	Created DATETIME,
	PersonId INT CONSTRAINT fk_BookingManagerMessage_pid FOREIGN KEY REFERENCES Persons(id),
	GlobalId NVARCHAR(450),
	ResourceId INT CONSTRAINT fk_BookingManagerMessage_rid FOREIGN KEY REFERENCES Resources(id),
	[Message] NTEXT,
	IsProcessing bit not null default 1
	);

	CREATE NONCLUSTERED INDEX [ix_BookingManagerMessage_GlobalId] 
	ON BookingManagerMessage ([GlobalId])
end
GO
-- add new column NewStartDate into BookingManagerMessage table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'NewStartDate' and Object_ID = Object_ID(N'BookingManagerMessage'))
 ALTER TABLE [dbo].[BookingManagerMessage] ADD [NewStartDate] [datetime] NULL
GO
-- add new column NewEndDate into BookingManagerMessage table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'NewEndDate' and Object_ID = Object_ID(N'BookingManagerMessage'))
 ALTER TABLE [dbo].[BookingManagerMessage] ADD [NewEndDate] [datetime] NULL
GO
-- add new column IsNewResource into BookingManagerMessage table
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'IsNewResource' and Object_ID = Object_ID(N'BookingManagerMessage'))
 ALTER TABLE [dbo].[BookingManagerMessage] ADD [IsNewResource] [bit] NULL
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RestoreBookingManager]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RestoreBookingManager]
GO
CREATE PROCEDURE [dbo].[RestoreBookingManager] 
@RestoringTime  As varchar(255)
AS
BEGIN
	IF (@RestoringTime Is NOT NULL AND ISNUMERIC(LTrim(RTrim(@RestoringTime)))=1 )  
	Begin
		UPDATE Reservations SET BookingManagerActive = 1,BookingManagerTime = GETUTCDATE()
		WHERE BookingManagerActive = 0 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(@RestoringTime))),GETUTCDATE()) > BookingManagerTime
		UPDATE BookingManagerMessage SET IsProcessing = 0
		WHERE IsProcessing = 1 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(@RestoringTime))),GETUTCDATE()) > Created
	END
	ELSE
	BEGIN
		UPDATE Reservations SET BookingManagerActive = 1,BookingManagerTime = GETUTCDATE()
		WHERE BookingManagerActive = 0 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(10))),GETUTCDATE()) > BookingManagerTime

		UPDATE BookingManagerMessage SET IsProcessing = 0
		WHERE IsProcessing = 1 
		AND DATEADD(MINUTE,-CONVERT(NUMERIC,LTRIM(RTRIM(10))),GETUTCDATE()) > Created
	END
END
GO
-- create procedure GetListReservationBookingManagerListView --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetListReservationBookingManagerListView]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetListReservationBookingManagerListView]
GO
CREATE PROCEDURE [dbo].[GetListReservationBookingManagerListView]
	@startTime datetime = null,
	@endTime datetime = null,
	@groupId int = null,
	@resourceIds nvarchar(max) = null,
	@locationIds nvarchar(max) = null,
	@organizerMail nvarchar(max) = null,
	@skip int = 0,
	@pageSize int = 50
AS
BEGIN
	-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Item from udfSplitStringV2(@resourceIds, ',')
-- split location ids list string into table
declare @locationIdsTbl table (id nvarchar(256))
insert into @locationIdsTbl
select Item from udfSplitStringV2(@locationIds, ',')
-- get all child resource is inprocess in booking manager
declare @childResources table(id int)
    insert into @childResources
    select cr.ChildResourceId from BookingManagerMessage bm
    inner join ChildResources cr on bm.ResourceId = cr.VirtualResourceId
    where bm.IsProcessing = 1 
	and bm.IsNewResource = 1
    AND bm.NewStartDate < @endTime 
	AND bm.NewEndDate >= @startTime
-- get total row number
declare @totalRows int = 0
select @totalRows = (select count(r.id)
			from Reservations r
			inner join Resources rc on r.RessourceId = rc.id
			left join @resourceIdsTbl rbl on rc.id = rbl.id
			left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
			--base condition
			where r.Active <> 0
				AND r.isrecurring <> 2 
				AND r.BusyStatus ='BUSY'
				--condition for recurring
				and (r.ParentReservationId is null or r.ParentReservationId <> 0)
				--additional condition
				AND r.StartDate >= Dateadd(day, -20, @startTime) 
				--current date condition
				AND r.StartDate < @endTime 
				AND r.EndDate > @startTime
				--booking manager active condition
				AND r.BookingManagerActive = 1
				AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
				AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
			)
			+ -- select booking manager inactive reservation
			(select count(A.id)
				from 
				(	select 
					distinct 
						r.id
					from BookingManagerMessage bm
					inner join Reservations r on bm.GlobalId = r.GlobalID
					inner join Resources rc on bm.ResourceId = rc.id
					inner join (
						select grByGlobalId.GlobalId, count(*) as cnt from 
								(
								select bm.GlobalId from BookingManagerMessage bm
								where bm.IsProcessing = 1 and bm.IsNewResource = 1
								) grByGlobalId
							group by grByGlobalId.GlobalId
						) gr on (gr.GlobalId = bm.GlobalId) AND (gr.cnt = 1 OR rc.RessourceMail is null)
					left join @resourceIdsTbl rbl on rc.id = rbl.id
					left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
					left join @childResources cr on bm.ResourceId = cr.id
					where bm.IsProcessing = 1
						and bm.IsNewResource = 1
						--condition for recurring
						and (r.ParentReservationId is null or r.ParentReservationId <> 0)
						--additional condition
						AND r.StartDate >= Dateadd(day, -20, @startTime) 
						--base condition
						AND r.Active <> 0
						AND r.isrecurring <> 2 
						AND r.BusyStatus ='BUSY'
						--current date condition
						AND bm.NewStartDate < @endTime 
						AND bm.NewEndDate > @startTime
						--booking manager active condition
						AND r.BookingManagerActive = 0
						AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
						AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
						AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
						AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
						AND cr.id is null
				)A
			)
-- start select data
select top (@pageSize)
	B.id,
	B.RessourceId AS ResourceId,
	B.Subject,
	B.StartDate,
	B.EndDate,
	B.Organizer,
	B.ResourceName,
	B.LocationPath,
	B.IsRecurring,
	B.OrganizerName,
	B.IsActive,
	B.CommonFormId,
	@totalRows as TotalRows
from
(
select 
	ROW_NUMBER() over(order by A.StartDate, A.EndDate) as rNumber,
	A.id,
	A.RessourceId,
	A.Subject,
	A.StartDate,
	A.EndDate,
	A.Organizer,
	A.ResourceName,
	A.LocationPath,
	A.IsRecurring,
	A.OrganizerName,
	A.IsActive,
	A.CommonFormId
	from
	(
		-- select booking manager active reservation
		-- select booking manager active reservation
		select 
			r.id,
			r.RessourceId,
			r.Subject,
			r.StartDate,
			r.EndDate,
			Isnull(r.organizeremail + ' (' 
										  + r.organizername + ')', r.organizeremail) AS Organizer,
			rc.Name as ResourceName,
			rc.LocationPath,
			r.IsRecurring,
			(SELECT top 1 pv.valuetext 
			FROM   dbo.propertytypes AS pt 
			INNER JOIN dbo.propertyvalues AS pv 
				ON pt.id = pv.propertyid 
				AND pt.name = 'RC_OrganizerName' 
				AND r.id = pv.reservationid)  
			AS OrganizerName,
			rc.SortOrder,
			1 as IsActive,
			rc.CommonFormId
		from Reservations r
		inner join Resources rc on r.RessourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where r.Active <> 0
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--condition for recurring
			and (r.ParentReservationId is null or r.ParentReservationId <> 0)
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		union all
		-- select booking manager inactive reservation
		select 
			BmTemp.id,
			BmTemp.RessourceId,
			BmTemp.Subject,
			BmTemp.StartDate,
			BmTemp.EndDate,
			BmTemp.Organizer,
			BmTemp.ResourceName,
			BmTemp.LocationPath,
			BmTemp.IsRecurring,
			BmTemp.OrganizerName,
			BmTemp.SortOrder,
			0 as IsActive,
			BmTemp.CommonFormId
		from
			(select 
				ROW_NUMBER() over (partition by r.GlobalID, bm.ResourceId order by r.id asc) as num,
				r.id,
				r.RessourceId,
				r.Subject,
				bm.NewStartDate as StartDate,
				bm.NewEndDate as EndDate,
				Isnull(r.organizeremail + ' (' 
											  + r.organizername + ')', r.organizeremail) AS Organizer,
				rc.Name as ResourceName,
				rc.LocationPath,
				r.IsRecurring,
				(SELECT top 1 pv.valuetext 
				FROM   dbo.propertytypes AS pt 
				INNER JOIN dbo.propertyvalues AS pv 
					ON pt.id = pv.propertyid 
					AND pt.name = 'RC_OrganizerName' 
					AND r.id = pv.reservationid)  
				AS OrganizerName,
				rc.SortOrder,
				rc.CommonFormId
			from BookingManagerMessage bm
				inner join Reservations r on bm.GlobalId = r.GlobalID
				inner join Resources rc on bm.ResourceId = rc.id
				inner join (
				select grByGlobalId.GlobalId, count(*) as cnt from 
						(
						select bm.GlobalId from BookingManagerMessage bm
						where bm.IsProcessing = 1 and bm.IsNewResource = 1
						) grByGlobalId
					group by grByGlobalId.GlobalId
				) gr on (gr.GlobalId = bm.GlobalId) AND (gr.cnt = 1 OR rc.RessourceMail is null)
				left join @resourceIdsTbl rbl on rc.id = rbl.id
				left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
				left join @childResources cr on bm.ResourceId = cr.id
				where bm.IsProcessing = 1
					and bm.IsNewResource = 1
					--condition for recurring
					and (r.ParentReservationId is null or r.ParentReservationId <> 0)
					--additional condition
					AND r.StartDate >= Dateadd(day, -20, @startTime) 
					--base condition
					AND r.Active <> 0
					AND r.isrecurring <> 2 
					AND r.BusyStatus ='BUSY'
					--current date condition
					AND bm.NewStartDate < @endTime 
					AND bm.NewEndDate > @startTime
					--booking manager active condition
					AND r.BookingManagerActive = 0
					AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
					AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
					AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
					AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
					AND (cr.id is null or r.VRReservationId is null)
				) BmTemp where BmTemp.num = 1
	) A
)B where B.rNumber > @skip
END 
GO
-- create procedure GetListResourceHasReservationPaging --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetListResourceHasReservationPaging]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetListResourceHasReservationPaging]
GO
CREATE procedure [dbo].[GetListResourceHasReservationPaging]
@startTime datetime = null,
@endTime datetime = null,
@groupId int = null,
@resourceIds nvarchar(max) = null,
@locationIds nvarchar(max) = null,
@organizerMail nvarchar(max) = null,
@skip int = 0,
@pageSize int = 50
as
begin
	-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Data from [dbo].[udfSplitString](@resourceIds, ',')
-- split location ids list string into table
declare @locationIdsTbl table (id nvarchar(256))
insert into @locationIdsTbl
select Item from udfSplitStringV2(@locationIds, ',')
-- get total row number
declare @totalRows int = 0
select @totalRows = count(A.ResourceId) from (
	select distinct
			rc.id as ResourceId
		from Resources rc
		inner join Reservations r on r.RessourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where (r.Active <> 0 OR isnull(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@groupId, '') = '' OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
	 union
	 select distinct
			rc.id as ResourceId
		from BookingManagerMessage bm
		inner join Reservations r on bm.GlobalId = r.GlobalID
		inner join Resources rc on bm.ResourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		where bm.IsProcessing = 1
			and bm.IsNewResource = 1
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--base condition
			AND r.Active <> 0
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 0
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
) A
 --start select data
select top (@pageSize) 
	B.ResourceId,
	B.ResourceName,
	B.StartTime,
	B.EndTime,
	B.CommonFormId,
	B.AllowConflictMeeting,
	B.AutoAcceptAgent, 
	@totalRows as TotalRows 
from 
(
	select distinct
		ROW_NUMBER() over(order by A.SortOrder, A.ResourceName) as rNumber,
		A.ResourceId,
		A.ResourceName,
		A.StartTime,
		A.EndTime,
		A.SortOrder,
		A.CommonFormId,
		A.AllowConflictMeeting,
		A.AutoAcceptAgent
	from
	(
		-- select booking manager active reservation
		select distinct
			rc.id as ResourceId,
			rc.StartTime,
			rc.EndTime,
			rc.Name as ResourceName,
			rc.SortOrder,
			rc.CommonFormId,
			rc.AllowConflictMeeting,
			rc.AutoAcceptAgent
		from Resources rc
		inner join Reservations r on r.RessourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where rc.Visible = 1
			AND (r.Active <> 0 OR isnull(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		union
		-- select booking manager inactive reservation
		select distinct
			rc.id as ResourceId,
			rc.StartTime,
			rc.EndTime,
			rc.Name as ResourceName,
			rc.SortOrder,
			rc.CommonFormId,
			rc.AllowConflictMeeting,
			rc.AutoAcceptAgent
		from BookingManagerMessage bm
		inner join Reservations r on bm.GlobalId = r.GlobalID
		inner join Resources rc on bm.ResourceId = rc.id
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		where rc.Visible = 1
			AND bm.IsProcessing = 1
			and bm.IsNewResource = 1
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--base condition
			AND r.Active <> 0
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--current date condition
			AND bm.NewStartDate < @endTime 
			AND bm.NewEndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 0
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
	) A
) B 
where B.rNumber > @skip
end
GO
-- create procedure GetListVisibleResourcePaging --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetListVisibleResourcePaging]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetListVisibleResourcePaging]
GO
CREATE procedure [dbo].[GetListVisibleResourcePaging]
@groupId int = null,
@resourceIds nvarchar(max) = null,
@locationIds nvarchar(max) = null,
@skip int = 0,
@pageSize int = 50
as
begin
	-- split resource ids list string into table
	declare @resourceIdsTbl table (id nvarchar(256))
	insert into @resourceIdsTbl
	select Data from [dbo].[udfSplitString](@resourceIds, ',')
	-- split location ids list string into table
	declare @locationIdsTbl table (id nvarchar(256))
	insert into @locationIdsTbl
	select Item from udfSplitStringV2(@locationIds, ',')
	-- get total row number
	declare @totalRows int = 0
	select @totalRows = count(rc.id) from Resources rc
			left join @resourceIdsTbl rbl on rc.id = rbl.id
			left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
			--base condition
			where rc.Visible = 1
				AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
	-- start select data
	select top (@pageSize) 
		B.ResourceId,
		B.ResourceName,
		B.StartTime,
		B.EndTime,
		B.CommonFormId,
		B.AllowConflictMeeting,
		B.AutoAcceptAgent, 
		@totalRows as TotalRows 
	from 
	(
		-- select booking manager active reservation
		select distinct
			ROW_NUMBER() over(order by rc.SortOrder, rc.Name) as rNumber,
			rc.id as ResourceId,
			rc.StartTime,
			rc.EndTime,
			rc.Name as ResourceName,
			rc.SortOrder,
			rc.CommonFormId,
			rc.AllowConflictMeeting,
			rc.AutoAcceptAgent
		from Resources rc
		left join @resourceIdsTbl rbl on rc.id = rbl.id
		left join @locationIdsTbl lbl on rc.LocationPath = lbl.id
		--base condition
		where rc.Visible = 1
			AND (ISNULL(@groupId, 0) = 0 OR @groupId = rc.GroupId)
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@locationIds, '') = '' OR lbl.id is not null)
	) B 
	where B.rNumber > @skip
end
GO
-- create procedure GetReservationBookingManagerCalendarView --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetReservationBookingManagerCalendarView]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetReservationBookingManagerCalendarView]
GO
CREATE procedure [dbo].[GetReservationBookingManagerCalendarView]
@startTime datetime = null,
@endTime datetime = null,
@groupId int = null,
@resourceIds nvarchar(max) = null,
@organizerMail nvarchar(max) = null
as
begin
-- split resource ids list string into table
declare @resourceIdsTbl table (id nvarchar(256))
insert into @resourceIdsTbl
select Item from udfSplitStringV2(@resourceIds, ',')
-- start select data
select 
	A.id,
	A.ResourceId,
	A.Subject,
	A.StartDate,
	A.EndDate,
	A.OrganizerEmail,
	A.OrganizerName,
	A.OriginalReservationId,
	A.IsActive,
	A.VRReservationId,
	A.ParentResourceIds
	from
	(
		-- select booking manager active reservation
		select distinct
			CONVERT(varchar, r.id) as id,
			r.RessourceId as ResourceId,
			r.Subject,
			r.StartDate,
			r.EndDate,
			r.OrganizerEmail,
			r.OrganizerName,
			r.id as OriginalReservationId,
			1 as IsActive,
			ISNULL(r.VRReservationId, 0) AS VRReservationId,
			[dbo].[fn_Resource_GetVRStringIds](r.RessourceId) as ParentResourceIds
		from Reservations r
		left join ChildResources rc on r.RessourceId = rc.ChildResourceId
		left join @resourceIdsTbl rbl on r.RessourceId = rbl.id
		--base condition
		where (r.Active <> 0 OR ISNULL(r.VRReservationId, 0) <> 0)
			AND r.isrecurring <> 2 
			AND r.BusyStatus ='BUSY'
			--condition for recurring
			and (r.ParentReservationId is null or r.ParentReservationId <> 0)
			--additional condition
			AND r.StartDate >= Dateadd(day, -20, @startTime) 
			--current date condition
			AND r.StartDate < @endTime 
			AND r.EndDate > @startTime
			--booking manager active condition
			AND r.BookingManagerActive = 1
			AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
			AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		union all
		-- select booking manager inactive reservation
		select distinct
			B.id,
			B.ResourceId as ResourceId,
			B.Subject,
			B.StartDate,
			B.EndDate,
			B.OrganizerEmail,
			B.OrganizerName,
			B.OriginalReservationId,
			0 as IsActive,
			B.VRReservationId,
			B.ParentResourceIds
		from
		(
			select 
				ROW_NUMBER() over (partition by r.GlobalID, bm.ResourceId order by r.id asc) as num,
				ISNULL(CAST(r.id as varchar(10)),'')+'-'+ISNULL(CAST(bm.ResourceId as varchar(10)),'') as id,
				bm.ResourceId as ResourceId,
				r.Subject,
				bm.NewStartDate as StartDate,
				bm.NewEndDate as EndDate,
				r.OrganizerEmail,
				r.OrganizerName,
				r.id as OriginalReservationId,
				CASE WHEN r.VRReservationId is null THEN -1 ELSE r.VRReservationId END AS VRReservationId,
				[dbo].[fn_Resource_GetVRStringIds](bm.ResourceId) as ParentResourceIds
			from BookingManagerMessage bm
			inner join Reservations r on bm.GlobalId = r.GlobalID 
			left join @resourceIdsTbl rbl on bm.ResourceId = rbl.id
			where bm.IsProcessing = 1
				and bm.IsNewResource = 1
				--condition for recurring
				and (r.ParentReservationId is null or r.ParentReservationId <> 0)
				--additional condition
				AND r.StartDate >= Dateadd(day, -20, @startTime) 
				--base condition
				AND r.Active <> 0
				AND r.isrecurring <> 2 
				AND r.BusyStatus ='BUSY'
				--current date condition
				AND bm.NewStartDate < @endTime 
				AND bm.NewEndDate > @startTime
				--booking manager active condition
				AND r.BookingManagerActive = 0
				AND (ISNULL(@resourceIds, '') = '' OR rbl.id is not null)
				AND (ISNULL(@organizerMail, '') = '' OR LOWER(r.OrganizerEmail) like LOWER(@organizerMail))
		)B where B.num = 1
	) A
end
go
-- create procedure GetConflictedReservationDates --------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetConflictedReservationDates]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetConflictedReservationDates]
GO
CREATE PROCEDURE [dbo].[GetConflictedReservationDates]
@ResourceID int,
@startDate DateTime,
@endDate DateTime,
@startTime dateTime,
@endTime dateTime,
@localStartTime dateTime
AS
BEGIN
Declare @PreBuffer int
Declare @PostBuffer int
Declare @ConflictedReservation as int
Declare @BufferConflictedReservation as int
Declare @localStartDate as DateTime
Declare @localEndDate as DateTime
Declare @localPBStartDate as DateTime
Declare @localPBEndDate as DateTime
Declare @DateDifference Int
Declare @CurrentDateNew DateTime
SET @CurrentDateNew=@StartTime
Select @DateDifference = DATEDIFF(s,@startTime,@localStartTime)
DECLARE  @TempResourceReservations TABLE(StartDate datetime,ConflictedReservation int)
Select @PreBuffer = ISNULL(PreBufferTime,0), @PostBuffer = ISNULL(PostBufferTime,0) From Resources Where [Id] = @ResourceId
INSERT @TempResourceReservations(StartDate,ConflictedReservation)
Select distinct 
    CASE WHEN StartDate < @startDate Then @startDate ELSE PBStartDate End as StartDate
	, CASE WHEN 
		(
			( PBStartDate  between convert(datetime,@startTime,101) and convert(datetime,@endTime,101) ) Or
			( PBEndDate  between convert(datetime,@startTime,101) and convert(datetime,@endTime,101) )   Or
			( convert(datetime,@startTime,101) between PBStartDate and PBEndDate ) OR 
			( convert(datetime,@endTime,101) between PBStartDate  and PBEndDate )
		) Then 1 ELSE 0 END AS ConflictedReservation
	From  
	(		 
		SELECT  dbo.Reservations.id, 
			DATEADD(s,@DateDifference,Reservations.StartDate) AS StartDate, 
			DATEADD(s,@DateDifference,dbo.Reservations.EndDate) AS EndDate, 
			DATEADD(s,@DateDifference,DATEADD(MINUTE, - (1 *  CASE WHEN ISNULL(@PreBuffer, 0) <> 0 THEN @PreBuffer ELSE dbo.Resources.PreBufferTime END), dbo.Reservations.StartDate)) AS PBStartDate, 
			DATEADD(s,@DateDifference,DATEADD(MINUTE, CASE WHEN ISNULL(@PostBuffer, 0) <> 0 THEN @PostBuffer ELSE dbo.Resources.PostBufferTime END, dbo.Reservations.EndDate)) AS PBEndDate, 
			dbo.Reservations.BusyStatus, dbo.Reservations.RessourceId, dbo.Reservations.Name, dbo.Reservations.OrganizerEmail
		FROM dbo.Reservations 
			INNER JOIN dbo.Resources ON dbo.Reservations.RessourceId = Resources.ID
		WHERE dbo.Reservations.Active = 1 AND dbo.Reservations.IsRecurring <> 2
		AND 
		(
			dbo.Reservations.RessourceId = @ResourceID
			OR dbo.Reservations.RessourceId IN (Select VirtualResourceId From ChildResources Where ChildResourceId = @ResourceID)
			OR dbo.Reservations.RessourceId IN (select ChildResourceId from ChildResources  Where VirtualResourceId = @ResourceID)
			OR dbo.Reservations.RessourceId IN 
					(select cr2.VirtualResourceId from ChildResources cr1
						INNER JOIN ChildResources cr2 ON cr1.ChildResourceId = cr2.ChildResourceId
						Where cr1.VirtualResourceId <> cr2.VirtualResourceId AND cr1.VirtualResourceId = @ResourceID)
		)
		AND (dbo.Reservations.OrderStatus <> 'DELETED' OR dbo.Reservations.OrderStatus IS NULL) 
		AND dbo.Reservations.BusyStatus <> 'FREE' 
	) as VR
	WHERE 
	 (  
		PBStartDate >= convert(datetime,@startDate,101) And PBStartDate < convert(datetime,@endDate,101)
     )
     OR 
     ( 
		PBEndDate > convert(datetime,@startDate,101) And PBEndDate <= convert(datetime,@endDate,101)
     )
     OR 
     ( 
		PBStartDate <= convert(datetime,@startDate,101) 
		And 
		PBEndDate Between convert(datetime,@startDate,101) And convert(datetime,@endDate,101)
     )
     OR 
     ( 
		PBEndDate >= convert(datetime,@endDate,101)
        And 
        PBStartDate Between convert(datetime,@startDate,101) And convert(datetime,@endDate,101) 
     )
     OR 
     ( 
		PBStartDate <= convert(datetime,@startDate,101) And PBEndDate >= convert(datetime,@endDate,101)
     )	
Declare @ConflictCount as int
Select @ConflictCount = Count(*) From @TempResourceReservations TempResourceReservations Where ConflictedReservation = 1 
IF ( @ConflictCount > 0 )
BEGIN
	SELECT StartDate From @TempResourceReservations TempResourceReservations Where ConflictedReservation = 1 
	RETURN 
END
END
GO

if not exists (select 1 from Tree where [Key]='BookingManager')
begin
-----insert into URLMapping-----
	declare @MaxFunctionId int = (select MAX(FunctionId) from URLMapping)
	declare @BookingManagerFunctionId int = @MaxFunctionId + 1
	insert into URLMapping(FunctionId,Created,LastUpdated,FunctionHandler) values(@BookingManagerFunctionId,GETUTCDATE(),GETUTCDATE(),'BookingManager.aspx')
-----insert into Tree-----
	declare @MaxTreeNodeId int = (select top 1 LastID from TableKeys where TableName = 'Tree')
	declare @BookingManagerNodeId int = @MaxTreeNodeId + 1
	declare @ParentNodeId int = (select top 1 id from Tree where [Key] = '@DAILYTASKS')
	insert into Tree(id,Created,LastUpdated,parentNodeId,[Key],Caption,SortOrder,IsApplicationNode,FunctionId,IconKey,CustomCalendarId,NodeType)
	values(@BookingManagerNodeId,GETUTCDATE(),GETUTCDATE(),@ParentNodeId,'BookingManager','Booking Manager',4,1,@BookingManagerFunctionId,'Orders',1,0)
-----insert into acl-----
	insert into acl(Created,LastUpdated,RoleId,TreeNodeId,actionId,Allow) 
	values(GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,1,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,2,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,3,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,4,1),
		  (GETUTCDATE(),GETUTCDATE(),1,@BookingManagerNodeId,5,1)
-----update TableKeys------------------
    Update TableKeys set LastID = @BookingManagerNodeId where TableName = 'Tree'
end
GO

--------------ToolBar "Clear Filter"-----------------------------
declare @MaxToolbarFunctionsId int = (select Max(id) from ToolbarFunctions)
declare @ClearFilterId int = @MaxToolbarFunctionsId + 1
IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@ClearFilter')
BEGIN
insert into ToolbarFunctions(id,FunctionName,Caption,DescriptionShort,iconRef) values(@ClearFilterId,'@ClearFilter','Clear Filter','Reset all filters for this view','../images/Filter.gif')
END

------------------sp_MiniRF_NormalResources_SelectedResourceList---------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_MiniRF_NormalResources_SelectedResourceList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_MiniRF_NormalResources_SelectedResourceList]
GO
CREATE PROCEDURE [dbo].[sp_MiniRF_NormalResources_SelectedResourceList]
@ResourceIDs varchar(512) = '',
@sortColumn varchar(100),
@sqlSortDir varchar(4),
@locationPath varchar(MAX),
@categoryList varchar(MAX),
@nameToSearch nvarchar(256),
@searchOperator varchar(2),
@capacityValue INT,
@filterAndOr INT,
@categoryFilter varchar(MAX),
@locationFilter varchar(MAX)
AS 
BEGIN
SET NOCOUNT ON
DECLARE @categoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @locationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterLocationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterCategoryTBL TABLE(Id INT,Data varchar(MAX))
INSERT @categoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryList,',') OPTION (MAXRECURSION 0)
INSERT @locationTBL
SELECT * FROM [dbo].[udfSplitString](@locationPath,',') OPTION (MAXRECURSION 0)
INSERT @filterLocationTBL
SELECT * FROM [dbo].[udfSplitString](@locationFilter,',') OPTION (MAXRECURSION 0)
INSERT @filterCategoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryFilter,',') OPTION (MAXRECURSION 0)
DECLARE @resInOrder TABLE(ID INT,Name nvarchar(256),ImageHref nvarchar(256),RessourceMail nvarchar(256),LocationPath INT,Capacity INT,AllowConflictMeeting INT,CommonFormId INT,SortOrder NVARCHAR(256),utcStartTime datetime,utcEndTime datetime)
INSERT @resInOrder
select  ID,Name,ImageHref,RessourceMail,LocationPath,Capacity,AllowConflictMeeting,
            CommonFormId,SortOrder ,StartTime as utcStartTime, EndTime as utcEndTime
from Resources R  
Where (ID in (select Data from [dbo].[udfSplitString](@ResourceIDs,',') WHERE Data !=''))
AND    (Name LIKE '%'+@nameToSearch+'%' OR @nameToSearch='')
AND(
	(@searchOperator ='=' AND Capacity = @capacityValue)
OR (@searchOperator ='>' AND Capacity > @capacityValue)
OR (@searchOperator ='<' AND Capacity < @capacityValue)
OR (@searchOperator ='>=' AND Capacity >= @capacityValue)
OR (@searchOperator ='<=' AND Capacity <= @capacityValue)
OR @capacityValue = -1)
AND 
(
(
Category1 IN (SELECT Data FROM @categoryTBL)
OR Category2 IN (SELECT Data FROM @categoryTBL)
OR Category3 IN (SELECT Data FROM @categoryTBL)
OR Category4 IN (SELECT Data FROM @categoryTBL)
OR Category5 IN (SELECT Data FROM @categoryTBL)
OR @categoryList = ''
)
AND
(
	LocationPath IN (SELECT Data FROM @locationTBL)
	--OR @locationPath = ''
)
)
AND (
	@filterAndOr=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR @locationFilter ='')
			AND (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR  @categoryFilter=''
				)
		)
	OR @filterAndOr =-1			
	)
AND	(
	@filterAndOr!=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR (@locationFilter ='' AND @categoryFilter=''))
			OR (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR (@locationFilter ='' AND @categoryFilter='')
				)
		)
	OR @filterAndOr =-1		
	)
AND CommonFormId IS NULL -- not include SOF resources.
SELECT * FROM @resInOrder
ORDER BY SortOrder,
		 CASE WHEN @sortColumn='name' AND @sqlSortDir = 'asc' THEN Convert(nvarchar(256),Name) END,
		 CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'asc'THEN Capacity END,
		 CASE WHEN @sortColumn='name' AND @sqlSortDir = 'desc' THEN Convert(nvarchar(256),Name) END DESC,
		 CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'desc' THEN Capacity END DESC
END
 
GO
-------------sp_MiniRF_ListNormalResources_Avaiable_Count------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_MiniRF_ListNormalResources_Avaiable_Count]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable_Count]
GO
CREATE PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable_Count]
(
@personId INT,
@startTime DATETIME,
@endTime DATETIME,
@startTimeTotalMinutes INT,
@endTimeTotalMinutes INT,
@locationPath varchar(MAX),
@categoryList varchar(MAX),
@nameToSearch nvarchar(256),
@searchOperator varchar(2),
@capacityValue INT,
@filterAndOr INT,
@categoryFilter varchar(MAX),
@locationFilter varchar(MAX)
)
AS
BEGIN
SET NOCOUNT ON
DECLARE @selectFrom INT,@selectTO INT
DECLARE @categoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @locationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterLocationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterCategoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @tempResourceRerveration TABLE(ResId INT)

INSERT @categoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryList,',') OPTION (MAXRECURSION 0)
INSERT @locationTBL
SELECT * FROM [dbo].[udfSplitString](@locationPath,',') OPTION (MAXRECURSION 0)
INSERT @filterLocationTBL
SELECT * FROM [dbo].[udfSplitString](@locationFilter,',') OPTION (MAXRECURSION 0)
INSERT @filterCategoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryFilter,',') OPTION (MAXRECURSION 0)
DECLARE @ResourceAssignment TABLE(ResourceId int)
INSERT INTO @ResourceAssignment SELECT DISTINCT ResourceId FROM [dbo].[RelationsAssignments] WHERE PersonId = @personId

INSERT INTO @tempResourceRerveration
SELECT DISTINCT id FROM (SELECT  rs.id, 
DATEADD(MINUTE, - (rs.PreBufferTime), r.StartDate) AS PBStartDate, 
DATEADD(MINUTE, rs.PostBufferTime, r.EndDate) AS PBEndDate,
rs.StartTime  AS utcStartTime,rs.EndTime AS utcEndTime 
FROM        Reservations r 
INNER JOIN  Resources rs
ON			r.RessourceId = rs.id 
WHERE		(r.Active = 1 OR r.BusyStatus='BUSY')
AND (IsRecurring <> 2) AND EXISTS (SELECT 1 FROM @ResourceAssignment WHERE ResourceId = rs.id)
)as tbl
where (PBStartDate>=@startTime AND PBStartDate<@endTime) 
OR (PBEndDate<=@endTime AND PBEndDate>@startTime)
OR (PBStartDate<=@startTime AND PBEndDate>=@endTime)
--Remove all Shared Order resources
union select id from Resources where CommonFormId is not null
--Remove all VR of its' child resource unavailable
insert @tempResourceRerveration
select DISTINCT VirtualResourceId from ChildResources where ChildResourceId in (select ResId from @tempResourceRerveration)

SELECT COUNT(id) AS "TotalRows"  from Resources
WHERE id IN (SELECT id FROM @ResourceAssignment) AND id NOT IN (SELECT ResId FROM @tempResourceRerveration)
AND (Visible IS NULL OR Visible='1')
AND (
(dbo.fn_Resource_OpenTimeToInt(StartTime)<=@startTimeTotalMinutes AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes) OR
(dbo.fn_Resource_OpenTimeToInt(StartTime)>=@startTimeTotalMinutes AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes) OR StartTime=EndTime)
AND (Name LIKE '%'+@nameToSearch+'%' OR @nameToSearch='')
AND(
	(@searchOperator ='=' AND Capacity = @capacityValue)
OR (@searchOperator ='>' AND Capacity > @capacityValue)
OR (@searchOperator ='<' AND Capacity < @capacityValue)
OR (@searchOperator ='>=' AND Capacity >= @capacityValue)
OR (@searchOperator ='<=' AND Capacity <= @capacityValue)
OR @capacityValue = -1)
AND 
(
(
Category1 IN (SELECT Data FROM @categoryTBL)
OR Category2 IN (SELECT Data FROM @categoryTBL)
OR Category3 IN (SELECT Data FROM @categoryTBL)
OR Category4 IN (SELECT Data FROM @categoryTBL)
OR Category5 IN (SELECT Data FROM @categoryTBL)
OR @categoryList = ''
)
AND
(
	LocationPath IN (SELECT Data FROM @locationTBL)
	--OR @locationPath = ''
)
)
AND (
	@filterAndOr=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR @locationFilter ='')
			AND (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR  @categoryFilter=''
				)
		)
	OR @filterAndOr =-1			
	)
AND	(
	@filterAndOr!=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR (@locationFilter ='' AND @categoryFilter=''))
			OR (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR (@locationFilter ='' AND @categoryFilter='')
				)
		)
	OR @filterAndOr =-1		
	)
AND CommonFormId IS NULL -- not include SOF resources.
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_MiniRF_ListNormalResources_Avaiable]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable]
GO
CREATE PROCEDURE [dbo].[sp_MiniRF_ListNormalResources_Avaiable] 
(
@personId INT,
@startTime DATETIME,
@endTime DATETIME,
@startTimeTotalMinutes INT,
@endTimeTotalMinutes INT,
@pageSize INT,
@pageIndex INT,
@sortColumn varchar(100),
@sqlSortDir varchar(4),
@locationPath varchar(MAX),
@categoryList varchar(MAX),
@nameToSearch nvarchar(256),
@searchOperator varchar(2),
@capacityValue INT,
@filterAndOr INT,
@categoryFilter varchar(MAX),
@locationFilter varchar(MAX)
)
AS
BEGIN
SET NOCOUNT ON
DECLARE @selectFrom INT,@selectTO INT
DECLARE @categoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @locationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterLocationTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @filterCategoryTBL TABLE(Id INT,Data varchar(MAX))
DECLARE @tempResourceRerveration TABLE(ResId INT)

INSERT @categoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryList,',') OPTION (MAXRECURSION 0)
INSERT @locationTBL
SELECT * FROM [dbo].[udfSplitString](@locationPath,',') OPTION (MAXRECURSION 0)
INSERT @filterLocationTBL
SELECT * FROM [dbo].[udfSplitString](@locationFilter,',') OPTION (MAXRECURSION 0)
INSERT @filterCategoryTBL
SELECT * FROM [dbo].[udfSplitString](@categoryFilter,',') OPTION (MAXRECURSION 0)
SET @selectFrom = (@pageIndex-1) * @pageSize + 1
SET @selectTO = @pageSize * (@pageIndex)
DECLARE @ResourceAssignment TABLE(ResourceId int)
INSERT INTO @ResourceAssignment SELECT DISTINCT ResourceId FROM [dbo].[RelationsAssignments] WHERE PersonId = @personId

INSERT INTO @tempResourceRerveration
SELECT DISTINCT id FROM (SELECT  rs.id, 
DATEADD(MINUTE, - (rs.PreBufferTime), r.StartDate) AS PBStartDate, 
DATEADD(MINUTE, rs.PostBufferTime, r.EndDate) AS PBEndDate,
rs.StartTime  AS utcStartTime,rs.EndTime AS utcEndTime 
FROM        Reservations r 
INNER JOIN  Resources rs
ON			r.RessourceId = rs.id 
WHERE		(r.Active = 1 OR r.BusyStatus='BUSY')
AND (IsRecurring <> 2) AND EXISTS (SELECT 1 FROM @ResourceAssignment WHERE ResourceId = rs.id)
)as tbl
where (PBStartDate>=@startTime AND PBStartDate<@endTime) 
OR (PBEndDate<=@endTime AND PBEndDate>@startTime)
OR (PBStartDate<=@startTime AND PBEndDate>=@endTime)
--Remove all Shared Order resources
union select id from Resources where CommonFormId is not null
--Remove all VR of its' child resource unavailable
insert @tempResourceRerveration
select DISTINCT VirtualResourceId from ChildResources where ChildResourceId in (select ResId from @tempResourceRerveration)

SELECT * FROM
(SELECT ID,Name,ImageHref,RessourceMail,LocationPath,Capacity,AllowConflictMeeting,AutoAcceptAgent,
			  CommonFormId,SortOrder,ROW_NUMBER() OVER (ORDER BY SortOrder,
													   CASE WHEN @sortColumn='name' AND @sqlSortDir = 'asc' THEN Convert(nvarchar(256),Name) END,
													   CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'asc'THEN Capacity END,
													   CASE WHEN @sortColumn='name' AND @sqlSortDir = 'desc' THEN Convert(nvarchar(256),Name) END DESC,
													   CASE WHEN @sortColumn='capacity' AND @sqlSortDir = 'desc' THEN Capacity END DESC) AS RN,StartTime as utcStartTime, EndTime as utcEndTime from Resources
WHERE id IN (SELECT id FROM @ResourceAssignment)
AND id NOT IN (SELECT ResId FROM @tempResourceRerveration)
AND (Visible IS NULL OR Visible='1')
AND (
(dbo.fn_Resource_OpenTimeToInt(StartTime)<=@startTimeTotalMinutes AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes) OR
(dbo.fn_Resource_OpenTimeToInt(StartTime)>=@startTimeTotalMinutes AND dbo.fn_Resource_CloseTimeToInt(EndTime)>=@endTimeTotalMinutes) OR StartTime=EndTime)
AND (Name LIKE '%'+@nameToSearch+'%' OR @nameToSearch='')
AND(
	(@searchOperator ='=' AND Capacity = @capacityValue)
OR (@searchOperator ='>' AND Capacity > @capacityValue)
OR (@searchOperator ='<' AND Capacity < @capacityValue)
OR (@searchOperator ='>=' AND Capacity >= @capacityValue)
OR (@searchOperator ='<=' AND Capacity <= @capacityValue)
OR @capacityValue = -1)
AND 
(
(
Category1 IN (SELECT Data FROM @categoryTBL)
OR Category2 IN (SELECT Data FROM @categoryTBL)
OR Category3 IN (SELECT Data FROM @categoryTBL)
OR Category4 IN (SELECT Data FROM @categoryTBL)
OR Category5 IN (SELECT Data FROM @categoryTBL)
OR @categoryList = ''
)
AND
(
	LocationPath IN (SELECT Data FROM @locationTBL)
	--OR @locationPath = ''
)
)
AND (
	@filterAndOr=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR @locationFilter ='')
			AND (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR  @categoryFilter=''
				)
		)
	OR @filterAndOr =-1			
	)
AND	(
	@filterAndOr!=0
		OR (
			(LocationPath IN (SELECT Data FROM @filterLocationTBL) OR (@locationFilter ='' AND @categoryFilter=''))
			OR (
					Category1 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category2 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category3 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category4 IN  (SELECT Data FROM @filterCategoryTBL)
				OR 	Category5 IN  (SELECT Data FROM @filterCategoryTBL)
				OR (@locationFilter ='' AND @categoryFilter='')
				)
		)
	OR @filterAndOr =-1		
	)
AND CommonFormId IS NULL -- not include SOF resources.
) temp
WHERE temp.RN BETWEEN @selectFrom AND @selectTO
END
GO
--------------udfReservationExcludeVRScreenView---------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.udfReservationExcludeVRScreenView') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[udfReservationExcludeVRScreenView] 
END
GO
CREATE FUNCTION [dbo].[udfReservationExcludeVRScreenView] ( 
@CurrentDate      AS DATETIME, 
@PreviousDayCount AS INT, 
@FutureDayCount   AS INT) 
returns TABLE 
AS 
    RETURN 
      (SELECT DISTINCT dbo.reservations.id                                                             AS ReservationsID,
                       dbo.reservations.startdate, 
                       dbo.reservations.enddate, 
                       dbo.resources.Name                                                           AS Resource,
                       dbo.reservations.subject, 
                       Isnull(dbo.reservations.organizeremail + ' (' 
                              + dbo.reservations.organizername + ')', dbo.reservations.organizeremail) AS Organizer,
                       dbo.reservations.isrecurring, 
                       dbo.resources.id                                                                AS ResourceID,
					   dbo.resources.AllowConflictMeeting											   AS ConflictingMeeting,
					   dbo.resources.AutoAcceptAgent											       AS AllowConflicts,
					   dbo.resources.StartTime														   AS StartTime,
					   dbo.resources.EndTime														   AS EndTime,
					   dbo.Resources.PreBufferTime                                                     AS PreBufferTime,
					   dbo.Resources.PostBufferTime                                                    AS PostBufferTime,
                       (SELECT pv.valuetext 
                        FROM   dbo.propertytypes AS pt 
                               INNER JOIN dbo.propertyvalues AS pv 
                                       ON pt.id = pv.propertyid 
                                          AND pt.name = 'RC_OrganizerName' 
                                          AND dbo.reservations.id = pv.reservationid)                  AS OrganizerName,
                       dbo.reservations.resourcelocation                                               AS Location,
                       resources.locationpath                                                          AS LocationPath,
                       IsRecurringCol = CASE 
                                          WHEN ( isrecurring IS NOT NULL 
                                                 AND isrecurring = 0 ) THEN '' 
                                          ELSE '<img src=''../images/check.gif''></img>' 
                                        END,
					   CommonFormId = ISNULL(dbo.resources.CommonFormId,0),
					   dbo.reservations.organizeremail AS OrganizerEmail,
					   ISNULL(dbo.reservations.organizername,'') AS OrgName,
					   dbo.resources.TimeZone_StandardName AS TimeZone_StandardName,
					   dbo.Resources.SortOrder as ResourceSortOrder
       FROM   dbo.reservations 
              INNER JOIN dbo.resources 
                      ON dbo.reservations.ressourceid = dbo.resources.id 
        WHERE  dbo.reservations.startdate >= Dateadd(day, -@PreviousDayCount, @CurrentDate) 
              AND dbo.reservations.startdate <= Dateadd(day, @FutureDayCount, @CurrentDate) 
              AND dbo.reservations.isrecurring <> 2 
			  AND dbo.Reservations.Active <> 0
              AND Reservations.BusyStatus='BUSY')

GO
-- create function udfSplitStringV2 ---
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.udfSplitStringV2') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[udfSplitStringV2] 
END
GO
CREATE FUNCTION [dbo].[udfSplitStringV2]
(
   @List       NVARCHAR(MAX),
   @Delimiter  NVARCHAR(255)
)
RETURNS @Items TABLE (Item NVARCHAR(4000))
WITH SCHEMABINDING
AS
BEGIN
   DECLARE @ll INT = LEN(@List) + 1, @ld INT = LEN(@Delimiter);
 
   WITH a AS
   (
       SELECT
           [start] = 1,
           [end]   = COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, 1), 0), @ll),
           [value] = SUBSTRING(@List, 1, 
                     COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, 1), 0), @ll) - 1)
       UNION ALL
       SELECT
           [start] = CONVERT(INT, [end]) + @ld,
           [end]   = COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, [end] + @ld), 0), @ll),
           [value] = SUBSTRING(@List, [end] + @ld, 
                     COALESCE(NULLIF(CHARINDEX(@Delimiter, 
                       @List, [end] + @ld), 0), @ll)-[end]-@ld)
       FROM a
       WHERE [end] < @ll
   )
   INSERT @Items SELECT [value]
   FROM a
   WHERE LEN([value]) > 0
   OPTION (MAXRECURSION 0);
 
   RETURN;
END
GO
--------------fn_Resource_GetVRStringIds---------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.fn_Resource_GetVRStringIds') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[fn_Resource_GetVRStringIds] 
END
GO
CREATE FUNCTION [dbo].[fn_Resource_GetVRStringIds]
(
	-- Add the parameters for the function here
	@ResourceId int
)
RETURNS nvarchar(max)
AS
BEGIN
	declare @result nvarchar(20) = ''
	select 
	@result = ISNULL(@result,'') +',' + ISNULL(CAST(cr.VirtualResourceId as varchar(10)),'')
	from ChildResources cr
	where ChildResourceId = @ResourceId
	return @result
END
GO
--------------fn_Resource_GetVRStringIds---------------------------------------------------------------
IF EXISTS (SELECT * FROM sys.objects 
            WHERE object_id = OBJECT_ID(N'dbo.fn_Resource_GetChildIds') 
            AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
      DROP FUNCTION [dbo].[fn_Resource_GetChildIds] 
END
GO
CREATE FUNCTION [dbo].[fn_Resource_GetChildIds]
(
	-- Add the parameters for the function here
	@ResourceId int
)
RETURNS nvarchar(max)
AS
BEGIN
	declare @result nvarchar(20) = ''
	select 
	@result = ISNULL(@result,'') + ',' + ISNULL(CAST(cr.ChildResourceId as varchar(10)),'')
	from ChildResources cr
	where VirtualResourceId = @ResourceId
	return @result
END
GO
---------------------------------------------------------
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsViolatedRecurringRules]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[IsViolatedRecurringRules]
GO
CREATE PROCEDURE [dbo].[IsViolatedRecurringRules] 
	-- Add the parameters for the stored procedure here
	@ReservationId int, 
	@Uid nvarchar(256),
	@OldDate datetime,
	@NewDate datetime
AS
BEGIN
DECLARE @Min datetime = (SELECT Min(StartDate)
						   FROM Reservations
						   WHERE [UID] = @Uid
							AND IsRecurring <> 2) 
DECLARE @MinOfMin datetime = FLOOR(CAST(@Min AS float)) 
DECLARE @MaxOfMin datetime = DATEADD(DAY, 1, @MinOfMin)
 
DECLARE @Max datetime = (SELECT Max(StartDate)
						   FROM Reservations
						   WHERE [UID] = @Uid
							AND IsRecurring <> 2) 
DECLARE @MinOfMax datetime = FLOOR(CAST(@Max AS float)) 
DECLARE @MaxOfMax datetime = DATEADD(DAY, 1, @MinOfMax) 

DECLARE @Current datetime = GETUTCDATE() 

DECLARE @ParentId INT = 0
SELECT @ParentId = r.ParentReservationId FROM Reservations r
WHERE id = @ReservationId

IF @OldDate BETWEEN @MinOfMin AND @MaxOfMin 
BEGIN 
	IF (@NewDate > @MaxOfMax) OR (@NewDate BETWEEN @MaxOfMin AND @MaxOfMax) OR (@NewDate < @Current) 
	BEGIN
		SELECT 1 
	END 
	ELSE
		SELECT 0 
END 
ELSE IF @OldDate BETWEEN @MinOfMax AND @MaxOfMax 
BEGIN 
	IF (@NewDate < @MinOfMin) OR (@NewDate BETWEEN @MinOfMin AND @MinOfMax) 
	BEGIN
		SELECT 3 
	END 
	ELSE
		SELECT 0 
END 
ELSE IF (@NewDate < @MinOfMin) OR (@NewDate > @MaxOfMax) OR ((SELECT count(*) FROM Reservations 
																WHERE [UID] = @Uid AND Active <> 0 AND id <> @ReservationId AND ParentReservationId = @ParentId AND (@NewDate BETWEEN FLOOR(CAST(StartDate AS float)) 
																	AND DATEADD(DAY, 1, FLOOR(CAST(StartDate AS float))))) <> 0) 
BEGIN
	SELECT 2 
END 
ELSE
	SELECT 0
END
GO

IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[sp_Reservation_SelectByDateAndResourceID_MiniRF]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[sp_Reservation_SelectByDateAndResourceID_MiniRF]
GO
CREATE PROCEDURE [dbo].[sp_Reservation_SelectByDateAndResourceID_MiniRF]
	@ResourceIDs nvarchar(1024),
	@startDate datetime,
	@endDate datetime
AS
BEGIN
	declare @newStartDate DateTime
	SET @newStartDate = Dateadd(day, -1, @startDate)
	declare @newEndDate DateTime 
	SET @newEndDate = Dateadd(day, 1, @endDate)
	--========================================================================
	DECLARE @tblRCids1 	TABLE(ID INT)
	DECLARE @tblRCids 	TABLE(ID INT)
	DECLARE @indexBegin int
	DECLARE @indexEnd int
	DECLARE @resourceId INT
	INSERT INTO @tblRCids SELECT Data FROM udfSplitString(@ResourceIDs,',') WHERE data is not null and data <> ''
	INSERT INTO @tblRCids1 select [ID] FROM @tblRCids
	insert into @tblRCids1
		SELECT VirtualResourceId FROM ChildResources WHERE ChildResourceId IN (SELECT t.id from @tblRCids t)
	insert into @tblRCids1	
		SELECT ChildResourceId FROM ChildResources  WHERE VirtualResourceId IN (SELECT t.id from @tblRCids t)
	insert into @tblRCids1	
		SELECT cr2.VirtualResourceId FROM ChildResources cr1
						INNER JOIN ChildResources cr2 ON cr1.ChildResourceId = cr2.ChildResourceId
						WHERE cr1.VirtualResourceId <> cr2.VirtualResourceId AND cr1.VirtualResourceId IN (SELECT t.id from @tblRCids t)
	DECLARE @tempResources	TABLE(ID INT, PreBufferTime INT , PostBufferTime INT)
	INSERT INTO @tempResources SELECT DISTINCT r.[ID], PreBufferTime, PostBufferTime FROM @tblRCids1 t INNER JOIN Resources r ON t.ID = r.id
SELECT id, 
       CASE 
         WHEN Datepart(hh, startdate) = 12 
              AND Datepart(mi, startdate) = 0 
              AND Datepart(ss, startdate) = 0 THEN Dateadd(ss, 1, startdate) 
         ELSE startdate 
       END AS StartDate, 
       CASE 
         WHEN Datepart(hh, enddate) = 12 
              AND Datepart(mi, enddate) = 0 
              AND Datepart(ss, enddate) = 0 THEN Dateadd(ss, 1, enddate) 
         ELSE enddate 
       END AS EndDate, 
       [Subject],OrganizerName,
       organizeremail, 
       ressourceid,
	   [uid]
FROM   (SELECT VR.id, 
               ( CASE 
                   WHEN startdate < @startDate THEN @startDate 
                   ELSE pbstartdate 
                 END )    AS StartDate, 
               ( CASE 
                   WHEN enddate > @endDate THEN @endDate 
                   ELSE pbenddate 
                 END )    AS EndDate, 
               organizeremail, 
               ressourceid,[Subject],OrganizerName,[uid]
        FROM   
        (
				SELECT reservations.id, 
                       reservations.startdate AS StartDate, 
                       reservations.enddate   AS EndDate, 
                       ( CASE 
                           WHEN t.prebuffertime <> 0 THEN 
                           Dateadd(minute, -( t.prebuffertime ), 
                           dbo.reservations.startdate) 
                           ELSE reservations.startdate 
                         END )                AS PBStartDate, 
                       ( CASE 
                           WHEN t.postbuffertime <> 0 THEN 
                           Dateadd(minute, t.postbuffertime, 
                           dbo.reservations.enddate) 
                           ELSE reservations.enddate 
                         END )                AS PBEndDate, 
                       reservations.ressourceid, 
                       reservations.organizeremail ,
					   reservations.[Subject],
					   reservations.[OrganizerName],
					   reservations.[UID]
                FROM   reservations with (index = idx_reservation_rf_2961)
                       INNER JOIN @tempResources t 
                               ON reservations.ressourceid = t.id 
                WHERE  ( 
							StartDate < @newEndDate and EndDate > @newStartDate
                            and
                            reservations.active = 1
                         )
        ) AS VR 
        WHERE  (pbstartdate < @EndDate  AND pbenddate > @StartDate) 
   ) tblReservation
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetResourcesReservationProcessed]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetResourcesReservationProcessed]
GO
CREATE PROCEDURE [dbo].[GetResourcesReservationProcessed]
    @ResourceEmail NVARCHAR(255),
    @ReservationUid VARCHAR(450),
    @StartTime DATETIME,
    @UpdateType INT,
    @CurrentReservationId INT,
    @Active INT
AS
BEGIN
    -- SET NOCOUNT ON added to prevent extra result sets from	
    SET NOCOUNT ON;
    DECLARE @HandledResources NVARCHAR(4000)
    DECLARE @OldChildrentResources NVARCHAR(4000)
    DECLARE @VrResources NVARCHAR(4000) = ''
    DECLARE @IsVRBook TINYINT = 0
    DECLARE @IsChangedVR INT = 0
    DECLARE @IsIncludeOrganizer TINYINT = 1
    DECLARE @Table_ResourcesEmails Table (Id int ,Data NVARCHAR(4000))
    DECLARE @Table_HandledResources Table (Id int ,Data NVARCHAR(4000))
    DECLARE @Table_VRResources Table (Id int ,Data NVARCHAR(4000))	
    DECLARE @ResourcesEmails NVARCHAR(Max)
    SELECT @ResourcesEmails = ResourceList FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid
    -- In case replace resource
    DECLARE @ReplaceWithResource NVARCHAR(255)
    DECLARE @OldGUID NVARCHAR(255) = ''
    DECLARE @OldReservationId int = -1,@VrReservationId INT = -1
    SELECT @ReplaceWithResource = ReplaceWithResource,@OldGUID = OldGUID FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid
    SELECT @OldReservationId = id FROM Reservations WHERE [GUID] = @OldGUID
    IF (@CurrentReservationId = @OldReservationId OR EXISTS (SELECT id FROM Reservations where VRReservationId = @OldReservationId))
        AND EXISTS (SELECT 1 FROM RC_Reservations_Temp 
            WHERE [UID] = @ReservationUid AND [ChildResourcesEmail] LIKE '%'+ @ResourceEmail +'%')
    BEGIN
        IF @UpdateType <> -1
        BEGIN
            SET @UpdateType = -1
            SET @IsChangedVR = 1
        END
    END
    --Get VR childrent emails
    IF @UpdateType = -1 --New reservation
    BEGIN
        IF @IsIncludeOrganizer = 0
            SELECT @VrResources = [ChildResourcesEmail] FROM RC_Reservations_Temp 
            WHERE [UID] = @ReservationUid AND [ChildResourcesEmail] LIKE '%'+ @ResourceEmail +'%'
        ELSE
            SELECT @VrResources = [ChildResourcesEmail] FROM RC_Reservations_Temp 
            WHERE [UID] = @ReservationUid AND [ChildResourcesEmail] LIKE '%'+ @ResourceEmail +'%'
    END
    ELSE
    BEGIN
        DECLARE @VrResourceId INT
        SELECT @VrResourceId = VR.RessourceId,@OldChildrentResources = @ResourcesEmails,@VrReservationId = id  FROM [dbo].[Reservations] VR 
            WHERE EXISTS(SELECT id FROM Reservations R WHERE R.[id] = @CurrentReservationId AND R.[VRReservationId] = VR.id)
            AND (VR.GUID = @OldGUID OR @OldGUID is null OR @OldGUID = '')
        ;WITH CTE AS
        (
            select RessourceMail from Resources r where exists(select ChildResourceId from ChildResources where VirtualResourceId = @VrResourceId AND ChildResourceId = r.id)
        )
        SELECT @VrResources = CASE(@VrResources) WHEN '' THEN  CTE.RessourceMail ELSE COALESCE(@VrResources + ';', '') + CTE.RessourceMail END FROM CTE
    END
    --Get attendees list from reservation
    INSERT INTO @Table_ResourcesEmails SELECT * FROM [dbo].[udfSplitString](@ResourcesEmails, ';')
    --Check booking process
    IF @UpdateType=-1 AND NOT EXISTS(SELECT ReservationUid FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid)
    BEGIN
        DECLARE @NumberResourceInBook int
        SELECT @NumberResourceInBook = COUNT(Id) FROM @Table_ResourcesEmails
        IF @NumberResourceInBook>1 
        BEGIN
            UPDATE  dbo.ReservationsProcessQueue
            SET     dbo.ReservationsProcessQueue.LatestResources = @ResourceEmail ,
                 dbo.ReservationsProcessQueue.DeletedResources =  null
            WHERE   dbo.ReservationsProcessQueue.ReservationUid = @ReservationUid
            --INSERT INTO ReservationsProcessQueue(ReservationUid,LatestResources,DeletedResources) VALUES(@ReservationUid,@ResourceEmail,NULL)
            --SET @HandledResources = @ResourceEmail
        END
        ELSE
        BEGIN
                    UPDATE  dbo.ReservationsProcessQueue
            SET     dbo.ReservationsProcessQueue.LatestResources = null ,
                 dbo.ReservationsProcessQueue.DeletedResources =  null
            WHERE   dbo.ReservationsProcessQueue.ReservationUid = @ReservationUid
            --INSERT INTO ReservationsProcessQueue(ReservationUid,LatestResources,DeletedResources) VALUES(@ReservationUid,NULL,NULL)
        END
    END
    ELSE
    BEGIN
        IF (@Active <> 0 OR @VrResources <> '' 
			OR (@Active = 0 AND (@OldGUID <> '' OR @ReplaceWithResource IS NOT NULL OR @ReplaceWithResource <> ''))) -- in case move order: RTS call deleted resource first and new reource later
        BEGIN
            SELECT @HandledResources = LatestResources FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid
            IF @HandledResources IS NOT NULL
                SET @HandledResources = @HandledResources + ';' + @ResourceEmail
            ELSE
                SET @HandledResources = @ResourceEmail
            INSERT INTO @Table_HandledResources SELECT * FROM [dbo].[udfSplitString](@HandledResources, ';')
            IF NOT EXISTS(SELECT re.Id FROM @Table_ResourcesEmails re LEFT JOIN @Table_HandledResources rh ON re.Data = rh.Data WHERE rh.Data IS NULL AND re.Data IS NOT NULL)
                UPDATE ReservationsProcessQueue SET LatestResources = NULL WHERE ReservationUid = @ReservationUid
            ELSE
                UPDATE ReservationsProcessQueue SET LatestResources = @HandledResources WHERE ReservationUid = @ReservationUid
        END
		IF(@VrResources <> '' AND EXISTS(SELECT rh.ID FROM ReservationHistory rh WHERE rh.ID = @CurrentReservationId AND rh.BusyStatus = 'TENTATIVE')
				AND NOT EXISTS (SELECT 1 FROM Reservations WHERE VRReservationId = @VrReservationId AND BusyStatus = 'TENTATIVE'))
		BEGIN
			UPDATE ReservationsProcessQueue SET LatestResources = NULL WHERE ReservationUid = @ReservationUid
		END
    END
    IF @VrResources <> ''--This could be a part of VR resource 
    BEGIN		
        INSERT INTO @Table_VRResources SELECT * FROM [dbo].[udfSplitString](@VrResources, ';')
        IF (@Active = 0 OR
		NOT EXISTS (SELECT vr.Id FROM  @Table_VRResources vr LEFT JOIN @Table_HandledResources re ON vr.Data = re.Data WHERE re.Data IS NULL AND vr.Data IS NOT NULL)
			OR 
			( EXISTS(SELECT rh.ID FROM ReservationHistory rh WHERE rh.ID = @CurrentReservationId AND rh.BusyStatus = 'TENTATIVE')
				AND NOT EXISTS (SELECT 1 FROM Reservations WHERE VRReservationId = @VrReservationId AND BusyStatus = 'TENTATIVE')) -- incase of accept for delegate resource
		)
        BEGIN
            SET @IsVRBook = 1
            IF @Active = 0--Case a childrent resource is deleted, mark VR reservation to delete				
            BEGIN
                UPDATE Reservations SET Active = 0 WHERE id IN (SELECT TOP 1 VRReservationId FROM Reservations WHERE id=@CurrentReservationId) AND Active = 1
             	IF(@ReplaceWithResource IS NULL OR @ReplaceWithResource = '')
             		SET @VrResources = ''
                SET @IsChangedVR = 0	
            END
            ELSE
            BEGIN
                SELECT TOP 1 @IsChangedVR =  r.id FROM Reservations r INNER JOIN Resources res ON r.RessourceId = res.id
                WHERE EXISTS (SELECT 1 FROM Reservations r1 
                                WHERE r1.id = @CurrentReservationId AND r1.UID = r.UID 
                                AND r1.StartDate = r.StartDate 
                                AND r1.RessourceId <> r.RessourceId)
                  AND Active = 1
			  AND r.IsRecurring = (SELECT IsRecurring FROM Reservations r1 
                                WHERE r1.id = @CurrentReservationId AND r1.UID = r.UID 
                                AND r1.StartDate = r.StartDate 
                                AND r1.RessourceId <> r.RessourceId)
                AND r.RessourceId IN (SELECT cr.ChildResourceId FROM ChildResources cr WHERE cr.VirtualResourceId = @VrResourceId)
                AND res.RessourceMail IN (SELECT Data FROM @Table_HandledResources)
                SET @IsVRBook = 1
               UPDATE Reservations SET Active = 0 WHERE id IN (SELECT TOP 1 VRReservationId FROM Reservations WHERE id=@IsChangedVR) AND Active = 1
            END
        END		
    END
    ELSE--This is a normal booking
    BEGIN
        IF @Active = 0--In case deleted of childrent resources(second child hit), set it as a processing of VR booking		
        BEGIN
            IF EXISTS(SELECT id FROM Reservations R WHERE R.[id] = @CurrentReservationId AND R.[VRReservationId] = R.id) 
            BEGIN
                SET @IsVRBook = 1

				INSERT INTO @Table_HandledResources SELECT * FROM [dbo].[udfSplitString]((SELECT LatestResources FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid), ';')
				INSERT INTO @Table_HandledResources SELECT * FROM [dbo].[udfSplitString](@ResourceEmail, ';')

				DECLARE @Table_ResourcesList Table (Id int,Data NVARCHAR(4000))
				INSERT INTO @Table_ResourcesList SELECT * FROM [dbo].[udfSplitString]((SELECT ResourceList FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid), ';')

				IF NOT EXISTS (SELECT 1 FROM @Table_ResourcesList tbl1 LEFT JOIN @Table_HandledResources tbl2 ON tbl1.Data = tbl2.Data WHERE tbl2.Data IS NULL)
				BEGIN
					 UPDATE ReservationsProcessQueue SET LatestResources = NULL WHERE ReservationUid = @ReservationUid
				END
            END
        END
    END

	-- Update master record after all child resource is changed from tentattive to transfer
	IF(@VrReservationId <> -1 AND NOT EXISTS (SELECT TOP 1 1 FROM Reservations r WHERE IsRecurring <> 2 AND r.[UID] = @ReservationUid AND r.BusyStatus = 'TENTATIVE' 
		AND EXISTS (SELECT TOP 1 cr.ChildResourceId FROM ChildResources cr WHERE cr.VirtualResourceId = @VrResourceId AND cr.ChildResourceId = r.RessourceId))
		AND EXISTS(SELECT rh.ID FROM ReservationHistory rh WHERE rh.ID = @CurrentReservationId AND rh.BusyStatus = 'TENTATIVE'))
	BEGIN
		UPDATE Reservations Set BusyStatus = 'BUSY' WHERE UID = @ReservationUid
	END

    SELECT LatestResources AS HandledResources,@VrResources AS VRResources,@IsVRBook AS IsVRBook,@IsChangedVR AS IsChangedVR,@ReplaceWithResource as ReplaceWithResource,@OldGUID as OldGUID FROM ReservationsProcessQueue WHERE ReservationUid = @ReservationUid    
END
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MOVE_TEMP_ORDERS]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[MOVE_TEMP_ORDERS]
GO
CREATE PROCEDURE [dbo].[MOVE_TEMP_ORDERS]
	@ResourceEmail NVARCHAR(255),
	@ResourceId INT,
	@ReservationId INT,
	@StartTime DATETIME,
	@Uid NVARCHAR(450)
AS
BEGIN TRANSACTION
	DECLARE @OrderPlaced INT
	DECLARE @TempReservationId AS INT
	DECLARE @IsRecurring AS INT
	DECLARE @ReplaceWithRes NVARCHAR(256)
	DECLARE @oldReservationID INT = -1
	DECLARE @oldResourceId INT = -1
	DECLARE @InsertedOrders TABLE(ReservationId INT, Guid NVARCHAR(256), StartTime DATETIME, EndTime DATETIME, OldReservationId INT)

	SET @OrderPlaced = 0
	IF (SELECT COUNT(ChildResourceId) FROM ChildResources WHERE VirtualResourceId = @ResourceId) <> 0 
	BEGIN
		DECLARE Cursor_TempReservation CURSOR FOR 
		SELECT [Id], IsRecurring, ReplaceWithReservation FROM RC_Reservations_Temp WHERE [Uid] = @Uid ORDER BY LastUpdated DESC
	END
	ELSE
	BEGIN
		DECLARE Cursor_TempReservation CURSOR FOR 
		SELECT [Id], IsRecurring, ReplaceWithReservation FROM RC_Reservations_Temp 
		WHERE RessourceId = @ResourceId AND [Uid]= @Uid ORDER BY LastUpdated DESC
	END
	--GET TEMP RESERVATIONS
	OPEN Cursor_TempReservation
		FETCH NEXT FROM Cursor_TempReservation INTO @TempReservationId, @IsRecurring, @ReplaceWithRes
	IF @@FETCH_STATUS = 0 --ONLY SELECT FIRST AND IGNORE THE REST.
	BEGIN
		IF (@IsRecurring = 0) 
		BEGIN
			--Whether this reservation will be replaced
			IF @ReplaceWithRes IS NOT NULL
			BEGIN
				DECLARE @vrReservation INT = -1 
				DECLARE @activeOlderReservation INT = 0 
				DECLARE @reservationUID NVARCHAR(255) = NULL 
				DECLARE @oldResourceEmail NVARCHAR(255) = NULL 
				DECLARE @attendees NVARCHAR(4000) 
				SELECT @vrReservation = VRReservationId, @activeOlderReservation = Active, @reservationUID = [uid], @oldResourceId = RessourceId 
				FROM Reservations WHERE [GUID] = @ReplaceWithRes

				SELECT @attendees = Attendees FROM Reservations WHERE id = @ReservationId
				--IF @vrReservation <> -1
				-- SELECT @ReplaceWithRes = [GUID] FROM Reservations WHERE id = @vrReservation
				SELECT @oldReservationID = Reservations.Id,@oldResourceEmail = Resources.RessourceMail 
				FROM Reservations 
				INNER JOIN Resources ON Reservations.ressourceid = Resources.id 
				WHERE [GUID] = @ReplaceWithRes

				EXECUTE [dbo].[usp_MoveOrderToNewResouce] @ReplaceWithRes, @ReservationId ,@OrderPlaced OUT

				DECLARE @waitingReservation INT = -1
				DECLARE @Table_VRResources Table (Id INT, Data NVARCHAR(4000)) 
				DECLARE @Table_ResourcesEmails Table (Id INT, Data NVARCHAR(4000))
				DECLARE @removeAnyChild INT = 1
				DECLARE @resourceList NVARCHAR(250) = ''

				DECLARE @LatestResources NVARCHAR(250) = ''
				SELECT @waitingReservation = WaitingReservation, @resourceList = ResourceList,@LatestResources = LatestResources 
				FROM ReservationsProcessQueue WHERE ReservationUid = @reservationUID
				SET @resourceList = REPLACE(@resourceList,@ResourceEmail + ';','')
				SET @resourceList = REPLACE(@resourceList,@ResourceEmail,'')

				IF(@resourceList = '')
					UPDATE ReservationsProcessQueue SET ResourceList = NULL, ReplaceWithResource = NULL, OldGUID = NULL, WaitingReservation = NULL, LatestResources = NULL 
					WHERE ReservationUid = @reservationUID
				ELSE
					UPDATE ReservationsProcessQueue SET ResourceList = @resourceList, ReplaceWithResource = NULL, OldGUID = NULL, WaitingReservation = NULL, LatestResources = NULL 
					WHERE ReservationUid = @reservationUID

				INSERT INTO @Table_ResourcesEmails SELECT * FROM [dbo].[udfSplitString](@attendees, ';')
				IF(@vrReservation = 0)
				BEGIN
					UPDATE Reservations SET VRReservationId = NULL WHERE id = @oldReservationID
					DECLARE @VrResources NVARCHAR(4000)
					;WITH CTE AS
					(
						SELECT RessourceMail FROM Resources r WHERE EXISTS(SELECT ChildResourceId FROM ChildResources WHERE VirtualResourceId = @oldResourceId AND ChildResourceId = r.id)
					)
					SELECT @VrResources = CASE(@VrResources) WHEN '' THEN CTE.RessourceMail ELSE COALESCE(@VrResources + ';', '') + CTE.RessourceMail END FROM CTE
					INSERT INTO @Table_VRResources SELECT * FROM [dbo].[udfSplitString](@VrResources, ';')
					
					IF NOT EXISTS (SELECT vr.Id FROM  @Table_VRResources vr LEFT JOIN @Table_ResourcesEmails re ON vr.Data = re.Data WHERE re.Data IS NULL AND vr.Data IS NOT NULL)
					BEGIN
						SET @removeAnyChild = 0
					END
				END
				IF (
				(@activeOlderReservation = 0 AND CHARINDEX(@oldResourceEmail,@LatestResources) < 1 )
				OR @activeOlderReservation <> 0  
				OR (
						(@vrReservation <> -1 AND @vrReservation IS NOT NULL) 
						AND @removeAnyChild = 1
					)
				OR (
					@activeOlderReservation <> 0 
					AND (@vrReservation = -1 OR @vrReservation IS NULL) 
					AND (@waitingReservation IS NULL OR  @waitingReservation <> @oldReservationID) 
					)
				)
				SET @oldReservationID = -1
			END
			ELSE
			BEGIN
				--PRINT 'TEST MESSAGE'
				--MAKE ORDERS PERMANENT
				EXECUTE [dbo].[MakeOrdersPermanent] @ReservationId, @TempReservationId, @OrderPlaced OUT
			END
			--REMOVE TEMPORARY DATA
			EXECUTE DBO.DELETE_TEMP_RESERVATION @TempReservationId
			IF (@@Error <> 0)
			BEGIN
				ROLLBACK
				RAISERROR('Error Removing data for temp reservaiton',16,1)
			END
			IF @OrderPlaced = 1
			BEGIN
				INSERT INTO @InsertedOrders SELECT [Id], Guid, StartDate, EndDate, @oldReservationID FROM Reservations WHERE [Id] = @ReservationId
			END
		END --@IsRecurring = 0
		ELSE 
		BEGIN
			SET @OrderPlaced = 0
			--GET ALL THE ACTUAL INSTANCES
			DECLARE @InstanceId INT
			DECLARE @InstanceStartTime DATETIME
			DECLARE @InstanceEndTime DATETIME  
			DECLARE CURSOR_ActualInstance CURSOR FOR
				SELECT [Id],StartDate,EndDate FROM Reservations WHERE ParentReservationId = @ReservationId

			OPEN CURSOR_ActualInstance
			FETCH NEXT FROM CURSOR_ActualInstance INTO @InstanceId, @InstanceStartTime, @InstanceEndTime
			WHILE @@FETCH_STATUS = 0
			BEGIN
				-- GET THE CORRESPONDING TEMP INSTANCE
				DECLARE @TempInstanceId INT
				DECLARE Cursor_TempInstance CURSOR FOR 
					SELECT [Id] FROM RC_Reservations_Temp 
					WHERE RessourceId = @ResourceId 
						AND StartDate = @InstanceStartTime AND EndDate = @InstanceEndTime 
						AND (id = @TempReservationId OR ParentReservationId = @TempReservationId)  
						AND IsRecurring = 1 
					ORDER BY LastUpdated DESC
				OPEN Cursor_TempInstance 
					FETCH NEXT FROM Cursor_TempInstance INTO @TempInstanceId
				IF @@FETCH_STATUS = 0 --ONLY PICK ONE RESERVATION
				BEGIN 
					--MAKE TEMP INSTANCE PERMANENT
					EXECUTE [dbo].[MakeOrdersPermanent] @InstanceId, @TempInstanceId, @OrderPlaced OUT
					IF @@Error <> 0
					BEGIN
						ROLLBACK
						RAISERROR('Error Inserting Instance Data', 16, 1)
					END
					--REMOVE TEMPORARY DATA
					EXECUTE DBO.DELETE_TEMP_RESERVATION @TempInstanceId
					IF @@Error <> 0
					BEGIN
						ROLLBACK
						RAISERROR('Error Removing data for temp Instance', 16, 1)
					END
					IF @OrderPlaced = 1
					BEGIN
						INSERT INTO @InsertedOrders SELECT [Id], [Guid], StartDate, EndDate,@oldReservationID FROM Reservations WHERE [Id] = @InstanceId
						SET @OrderPlaced = 0
					END
					FETCH NEXT FROM Cursor_TempInstance INTO @TempInstanceId
				END
				CLOSE Cursor_TempInstance
				DEALLOCATE Cursor_TempInstance 
				FETCH NEXT FROM CURSOR_ActualInstance INTO @InstanceId, @InstanceStartTime, @InstanceEndTime
			END
			--REMOVE TEMPORARY DATA FOR MASTER INSTANCE
			EXECUTE DBO.DELETE_TEMP_RESERVATION @TempReservationId
			IF @@Error <> 0
			BEGIN
				ROLLBACK
				RAISERROR('Error Removing data for temp Instance',16,1)
			END
			CLOSE CURSOR_ActualInstance
			DEALLOCATE CURSOR_ActualInstance
		END 
	END --End Cursor_TempReservation
	CLOSE Cursor_TempReservation
	DEALLOCATE Cursor_TempReservation 
COMMIT --End Transaction
SELECT * FROM @InsertedOrders
GO
 DECLARE @lastIdOfParametersInTableKey INT
 SELECT @lastIdOfParametersInTableKey = Max(id)+1 FROM [Parameters]
 
 IF NOT EXISTS (SELECT [dbo].[Parameters].[key]
             FROM   [dbo].[Parameters]
			 WHERE  [dbo].[Parameters].[key] = 'BookingManager.RestoringTime')	  
      BEGIN			 		 
			 INSERT [dbo].[Parameters] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [key], [Name], [Value]) 
			 VALUES (@lastIdOfParametersInTableKey, GETDATE(), NULL, GETDATE(), NULL, N'BookingManager.RestoringTime', NULL,10)		 		     
      END
UPDATE TableKeys SET LastID = @lastIdOfParametersInTableKey WHERE TableName = 'Parameters'
GO

---- HaLV added
DECLARE @maxIdTree int = (select Max(id) from Tree)
IF NOT EXISTS (SELECT 1 FROM Tree WHERE [Key] = 'BookingManager')
BEGIN
 SET @maxIdTree = @maxIdTree + 1
 INSERT INTO [dbo].[Tree] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [parentNodeId], [Key], [Caption], [SortOrder], [Description], [URL], [IsApplicationNode], [FunctionId], [IconKey], [CustomCalendarId], [ExtraID1], [NodeType], [FullPath]) VALUES (@maxIdTree, GETDATE(), NULL, NULL, NULL, 4, N'BookingManager', N'Booking Manager', 9, NULL, NULL, 1, 1519259, N'Booking Manager', 1, NULL, 0, NULL)

 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 1 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES (GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 1, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 2 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 2, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 3 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ([Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 3, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 4 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 4, 1, NULL)
 END
 IF NOT EXISTS (SELECT 1 FROM acl WHERE [RoleId] = 1 AND [TreeNodeId] = @maxIdTree AND [actionId] = 5 AND [Allow] = 1)
 BEGIN
  INSERT INTO [dbo].[acl] ( [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [RoleId], [TreeNodeId], [actionId], [Allow], [IsLocked]) VALUES ( GETDATE(), 1, NULL, NULL, 1, @maxIdTree, 5, 1, NULL)
 END
END
-- Toolbar
 
DECLARE @maxIdToolbarFunctions int = (select Max(id) from ToolbarFunctions)
IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@SaveAndClose')
BEGIN
 SET @maxIdToolbarFunctions =  @maxIdToolbarFunctions +1
INSERT INTO [dbo].[ToolbarFunctions] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [FunctionName], [Caption], [DescriptionShort], [requestConfirmation], [iconRef], [ACLtype], [IconRef2007]) VALUES (@maxIdToolbarFunctions, NULL, NULL, NULL, NULL, N'@SaveAndClose', N'Save and Close', NULL, NULL, NULL, 4, NULL)
END

--Precompile
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[spEXECsp_RECOMPILE]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [dbo].[spEXECsp_RECOMPILE]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
CREATE PROCEDURE [dbo].[spEXECsp_RECOMPILE] AS 
SET NOCOUNT ON 
-- 1 - Declaration statements for all variables
DECLARE @TableName varchar(128)
DECLARE @OwnerName varchar(128)
DECLARE @CMD1 varchar(8000)
DECLARE @TableListLoop int
DECLARE @TableListTable table (UIDTableList int IDENTITY (1,1), OwnerName varchar(128), TableName varchar(128), ObjType varchar(128))
-- 2 - Outer loop for populating the database names
INSERT INTO @TableListTable(OwnerName, TableName, ObjType)
SELECT u.[Name], o.[Name], o.[type] FROM sys.objects o INNER JOIN sys.schemas u ON o.schema_id  = u.schema_id WHERE o.Type in ('U','P','IF','TF','FN','V') ORDER BY o.[type]
-- 3 - Determine the highest UIDDatabaseList to loop through the records
SELECT @TableListLoop = MAX(UIDTableList) FROM @TableListTable
-- 4 - While condition for looping through the database records
WHILE @TableListLoop > 0
 BEGIN
 -- 5 - Set the @DatabaseName parameter
 SELECT @TableName = TableName,  @OwnerName = OwnerName FROM @TableListTable WHERE UIDTableList = @TableListLoop
 -- 6 - String together the final backup command
 SELECT @CMD1 = 'EXEC sp_recompile ' + '[' + @OwnerName + '.' + @TableName + ']' + char(13)
 -- 7 - Execute the final string to complete the backups
 -- SELECT @CMD1
 EXEC (@CMD1)
 -- 8 - Descend through the database list
 SELECT @TableListLoop = @TableListLoop - 1
 END
SET NOCOUNT OFF
GO
IF NOT EXISTS (Select 1 FROM Icon Where IconKey = 'BookingManager')
INSERT INTO [dbo].[Icon]
           ([IconKey]
           ,[URL])
     VALUES
           ('BookingManager','../images/booking-manager.gif')
GO
Update Tree Set IconKey = 'BookingManager' Where [Key] = 'BookingManager'
GO
--ADD Import Visitor Toolbar 
DECLARE @maxIdToolbarFunctions int = (select Max(id) from ToolbarFunctions)
IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@ImportVisitor')
BEGIN
 SET @maxIdToolbarFunctions =  @maxIdToolbarFunctions +1
INSERT INTO [dbo].[ToolbarFunctions] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [FunctionName], [Caption], [DescriptionShort], [requestConfirmation], [iconRef], [ACLtype], [IconRef2007]) VALUES (@maxIdToolbarFunctions, NULL, NULL, NULL, NULL, N'@ImportVisitor', N'Import Visitors', 'Import visitors from Excel file.', NULL, '../images/Excel.gif', 4, '../images/Excel.gif')
END
GO
IF EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@ExcelTemplate')
BEGIN
  DELETE FROM  dbo.ToolbarFunctions   WHERE  FunctionName  = '@ExcelTemplate'
END
GO
DECLARE @maxIdToolbarFunctions int = (select Max(id) from ToolbarFunctions)
IF NOT EXISTS (SELECT 1 FROM ToolbarFunctions WHERE FunctionName = '@DowloadTemplate')
BEGIN
SET @maxIdToolbarFunctions =  @maxIdToolbarFunctions +1
INSERT INTO [dbo].[ToolbarFunctions] ([id], [Created], [CreatedBy], [LastUpdated], [LastUpdatedBy], [FunctionName], [Caption], [DescriptionShort], [requestConfirmation], [iconRef], [ACLtype], [IconRef2007]) VALUES (@maxIdToolbarFunctions, NULL, NULL, NULL, NULL, N'@DowloadTemplate', N'Download Template', 'Get Excel template file.', NULL, '../images/Excel.gif', 4, '../images/Excel.gif')
END
GO
--TFS#58824 
UPDATE ToolbarFunctions SET ACLtype = 4 WHERE 
( FunctionName='@SetPassword' ) OR (FunctionName='@Roles')  OR (FunctionName='@SaveConfigurations')  OR (FunctionName='@EditForm') OR (FunctionName='@EditTemplate')
GO
UPDATE ToolbarFunctions SET ACLtype  =5 WHERE FunctionName='@Remove'
GO
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHTMLFormByLanguage]') AND TYPE IN (N'P', N'PC'))
DROP PROCEDURE [dbo].[GetHTMLFormByLanguage]
GO
CREATE PROCEDURE [dbo].[GetHTMLFormByLanguage] 
	-- Add the parameters for the stored procedure here
	@languageCode nvarchar(50),
	@resId int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
	DECLARE @formId int
	SET @formId = -1
    -- Insert statements for procedure here
	SELECT @formId = FormHtml.id FROM Resources,FormHtml 
    WHERE FormHtml.id = CASE 
						   WHEN (Resources.CommonFormId is not null AND EXISTS (SELECT 1 FROM Parameters WHERE [key] = 'EnableSOF' and Value = '1'))  THEN Resources.CommonFormId 
						   ELSE  Resources.htmlid 
					    END
    AND Resources.id = @resId
	IF @formId <> -1
	BEGIN
		IF EXISTS(SELECT Id FROM FormLanguages WHERE [Language] = @languageCode AND FormHtmlId = @formId)
	        SELECT f.Content AS FormHtmlContent FROM FormLanguages f WHERE f.[Language] = @languageCode AND f.FormHtmlId = @formId
        ELSE
	        SELECT f.HTML AS FormHtmlContent FROM FormHTML f WHERE f.id = @formId
	END
END
--ThanhPS - Fix #12101: RCAdmin\Tasks: Cannot view any tasks on task list

GO
declare @MaxId int

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 3 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',3,'nb','Ressurs','Ressurs for reservasjonen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 4 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',4,'nb','Starttid:','Starttid for reservasjonen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 5 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',5,'nb','Sluttid','Sluttid for reservasjonen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 6 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',6,'nb','Handling','Sann hvis reservasjon er aktiv på Exchange-server, ellers usann')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 7 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',7,'nb','Arbeidsflyt-ID','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 9 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',9,'nb','Navn','Brukes for identifisering av denne posten i andre former')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 11 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',11,'nb','Beskrivelse','En kort beskrivelse. Opptil 255 tegn.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 12 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',12,'nb','Innhold','Innholdet er integrert i bestillingsskjemaet i Resource Central ')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 13 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',13,'nb','Lisensfil','Klikk på knappen Bla gjennom og velg navnet og banen til lisenfilen som du har mottatt fra Add-On Products')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 14 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',14,'nb','Lisensnøkkelfil','Klikk på knappen Bla gjennom og velg navnet og banen til lisenfilen som du har mottatt fra Add-On Products')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 15 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',15,'nb','Navn','Navnet på elementet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 16 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',16,'nb','Sted','Plasseringen av elementet.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 17 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',17,'nb','Gruppenavn','Gruppenavn for element')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 18 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',18,'nb','Utsalgspris','Salgsprisen for elementet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 19 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',19,'nb','Sorteringsrekkefølge','Sorteringsrekkefølgen for elementet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 20 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',20,'nb','Antall','En ID for å identifisere posten')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 21 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',21,'nb','Beskrivelse','En beskrivelse av varen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 22 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',22,'nb','Tabellnavn','En verdi som brukes for å gruppere oppslagsverdier sammen, for eksempel verdier som PROSJEKT, FIRMA, ANSATT')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 23 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',23,'nb','Navn','Navnet på egenskapen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 24 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',24,'nb','Antall','En ID for å identifisere posten')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 25 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',25,'nb','Tekst','Visningsnavn på egenskapen. Denne verdien vises når du setter inn et felt på et underskjema samt i e-post med bestillingsbekreftelse')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 27 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',27,'nb','Navn','En ID for å identifisere posten')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 28 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',28,'nb','Tips','Dette er \"verktøytips\" for feltet - det aktiveres når du holder musen over feltet.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 29 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',29,'nb','Tittellinje','Denne teksten vises på venstre side av ResourceFinder')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 30 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',30,'nb','Beskrivelse','En kort beskrivelse. Opptil 255 tegn.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 31 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',31,'nb','Antall','Navn på egenskapen. Denne verdien kan brukes i det tilpassede bestillingsskjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 32 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',32,'nb','Forside','Velg Ja hvis dette søket skal vises i ResourceFinder')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 33 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',33,'nb','Beskrivelse','En kort beskrivelse. Opptil 255 tegn.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 34 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',34,'nb','Sorteringsrekkefølge','Sorteringsrekkefølgen kan brukes med enhver alfanumerisk verdi og brukes til sortering av egenskapene i ResourceFinder')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 35 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',35,'nb','Sendt til','Dette feltet styrer hvem informasjonen skal sendes til')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 36 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',36,'nb','Sorteringsrekkefølge','Sorteringsrekkefølgen kan brukes med enhver alfanumerisk verdi og brukes til sortering av egenskapene')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 37 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',37,'nb','Treposisjon','Dette identifiserer faktisk \"treposisjon\" der søket starter')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 38 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',38,'nb','Obligatorisk','Hvis du velger \"Ja\", gjør du denne egenskapen obligatorisk. Nedenfor kan du angi en melding som skal vises til brukeren når denne egenskapen ikke er angitt')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 40 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',40,'nb','Melding','Dette er meldinger som vises til brukeren når brukeren prøver å ferdigstille en bestilling uten å skrive inn noe for denne egenskapen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 41 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',41,'nb','Ressurs','Ressurs for reservasjonen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 42 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',42,'nb','Aktiv','Sann hvis reservasjon er aktiv på Exchange-server, ellers usann')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 43 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',43,'nb','Nøkkelkunde','Parameternøkkel')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 44 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',44,'nb','verdi','Parameterverdi')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 48 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',48,'nb','Beskrivelse','Parameterbeskrivelse')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 49 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',49,'nb','Bilde','Velg et bilde av ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 50 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',50,'nb','Kategori','Kategori')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 51 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',51,'nb','Gruppenavn','Velg gruppenavn for denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 52 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',52,'nb','Kapasitet','Dette er valgfritt, men dette tallet brukes for å indikere den maksimale kapasiteten til ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 53 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',53,'nb','Minimum antall timer','Et minste antall timer før møtet som ressursen må bestilles på forhånd for å få full service')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 54 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',54,'nb','Startkostnad','Den opprinnelige kostnaden for ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 55 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',55,'nb','Kostnad per minutt','Kostnaden per minutt for ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 56 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',56,'nb','Skjema','Velg bestillingsskjemaet som skal brukes når det foretas en bestilling til denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 57 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',57,'nb','Maksimalt antall leveranser','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 58 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',58,'nb','Spør etter deltakerne i bestillingsskjemaet','Skal brukeren kunne registrere deltakerne?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 59 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',59,'nb','Exchange-alias','Velg Exchange-alias for denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 60 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',60,'nb','Ressurse-e-post','Velg ressurs-e-post for denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 61 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',61,'nb','Eiers e-post','Velg eier-e-post for denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 64 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',64,'nb','Navn','Angi et beskrivende navn på ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 65 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',65,'nb','Beskrivelse','En kort beskrivelse av ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 66 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',66,'nb','Navn','En ID for å identifisere posten')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 68 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',68,'nb','Beskrivelse','En kort beskrivelse av rollen. Opptil 255 tegn.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 70 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',70,'nb','Rollen er en sikkerhetsrolle','Er denne rollen en sikkerhetsrolle? - (skal den ha tilgang til sikkerhetsdelen av Resource Central?)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 71 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',71,'nb','Rollen kan redigere bestillinger','Skal denne rollen kunne redigere elementene i bestillingen når de svarer på meldinger?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 72 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',72,'nb','Undertrykk e-post','Når du sender meldinger til personer, kan e-post bare undertrykkes hvis de inneholder meldinger relatert til roller med flagget satt til Ja')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 73 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',73,'nb','Påloggingsnavn','Navnet som brukes til å logge på Resource Central')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 74 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',74,'nb','Visningsnavn','Dette identifiserer navnet som skal brukes ved visning eller utskrift av rapporter')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 75 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',75,'nb','Beskrivelse','En kort beskrivelse av personen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 76 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',76,'nb','Passord','Passord')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 77 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',77,'nb','SMTP-adresse','SMTP-adressen til personen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 78 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',78,'nb','Active Directory-treff','Skal brukeren bli matchet med Active Directory?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 79 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',79,'nb','Sted','Hvor befinner personen seg?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 80 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',80,'nb','Sted 2','Hvor befinner personen seg?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 81 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',81,'nb','Sted 3','Hvor befinner personen seg?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 82 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',82,'nb','E-post','Angi SMTP-adressen til ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 85 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',85,'nb','Sted','Velg stedet for ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 87 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',87,'nb','Tittellinje','Dette er en tittellinje til noden.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 88 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',88,'nb','Beskrivelse','Angi en kort beskrivelse for noden.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 89 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',89,'nb','Nøkkelkunde','En unik nøkkel for å identifisere noden (kan være tom).')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 90 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',90,'nb','URL','Dette er nettadressen som skal åpnes når noden er valgt. For tilpassede noder kan du sette siden i programmets mappe for tilpassede sider og plassere sidenavnet her, for eksempel MyCustomPage.aspx.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 91 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',91,'nb','Rollen kan vise alle meldinger','Rollen kan vise alle meldinger')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 92 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',92,'nb','Navn','Angi den besøkendes navn')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 93 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',93,'nb','Selskap','Angi den besøkendes ledsagere')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 94 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',94,'nb','E-post','Angi den besøkendes e-postadresse')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 95 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',95,'nb','Mobilnummer','Angi celle. / mobilnummer for den besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 96 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',96,'nb','Kategori','Angi en kategori for besøkende (valgfritt)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 97 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',97,'nb','Kommentar','Angi en kommentar om den besøkende (valgfritt)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 98 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',98,'nb','Tittel','Angi en tittel for den besøkende (valgfritt)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 99 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',99,'nb','Ikonnøkkel','Velg et ikon fra oppslagsvinduet for å forbinde ikonet med noden (hvis det brukes et tomt standardikon).')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 100 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',100,'nb','Lagre','Lagre og lukk vinduet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 101 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',101,'nb','Avbryt','Lukk vinduet uten å lagre')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 102 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',102,'nb','Lagre','Lagre og lukk vinduet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 103 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',103,'nb','Avbryt','Lukk uten å lagre')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 104 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',104,'nb','Alvorlighetsgrad','Programfeil på loggnivå')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 105 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',105,'nb','Tidsluke','Lengde på tidsluker som brukes i Resource Central')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 106 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',106,'nb','Exchange e-postserver','Angi DNS-navnet på Exchange-serveren eller en annen SMTP-server som tillater videresending til adressert e-post som brukes for ressursene i Resource Central')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 107 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',107,'nb','Språk','Velg språket som skal brukes i e-poster og bestillingsskjemaer innenfor Resource Central')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 108 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',108,'nb','Antall','Et nummer for å identifisere elementet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 109 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',109,'nb','Navn','Angi et gyldig navn på elementet. Ugyldige tegn omfatter* / \\ % ^ + = } { ] [ ! ~ ‘ \\')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 110 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',110,'nb','Innkjøpspris','Angi innkjøpspris på varen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 111 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',111,'nb','Nytt passord','Angi et nytt passord for denne personen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 112 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',112,'nb','Gjenta det nye passordet','Gjenta det nye passordet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 113 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',113,'nb','Hovedlogo','Logoen som vises på innloggingsskjermen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 114 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',114,'nb','Exchange-kalender','Angi riktig skrivemåte for Exchange-kalendere')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 115 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',115,'nb','Navn på skilt','Navnet på ressursen i RC Digital Signage-tjenesten.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 116 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',116,'nb','Klokkeslettformat','Velg klokkesletformat')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 117 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',117,'nb','Bruk standardtidssone','Velg å bruke standard tidssone eller ikke')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 118 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',118,'nb','Tidssone','Velg standardtidssone')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 119 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',119,'nb','Tidssone','Velg tidssone for ressurs')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 120 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',120,'nb','Tidssone','Velg tidssone for person')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 121 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',121,'nb','Navn','Navn på navneskilt')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 122 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',122,'nb','Er standard','Velg Ja for å angi dette navneskiltet som standard')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 123 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',123,'nb','Forbindelsestype','Velge typen som den besøkende er forbundet med')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 124 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',124,'nb','Reservasjonsnavn','Velg reservasjonsnavnet som den besøkende skal forbindes med')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 125 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',125,'nb','Avdelingsnavn','Velg avdeling som den besøkende skal forbindes med')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 126 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',126,'nb','Personer','Velg personen som den besøkende skal forbindes med')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 127 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',127,'nb','Navneskilttype','Velg navneskilttype som skal brukes for denne besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 128 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',128,'nb','iD-type','Velg type identifikasjon du ønsker å registrere for denne besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 129 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',129,'nb','ID-nummer','Angi ID-nummeret til den besøkendes identifikasjonsdokumentet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 130 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',130,'nb','Personsteder','Velg stedet for personen eller avdelingen som den besøkende er forbundet med')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 131 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',131,'nb','Bredde','Angi bredden på navneskiltet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 132 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',132,'nb','Høyde','Angi høyden på navneskiltet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 133 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',133,'nb','RA. Antall forekomster','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 134 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',134,'nb','Send e-post','Velg for å sende e-post eller ikke')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 135 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',135,'nb','Datoformat','Velg datoformatet som skal brukes i e-post for behandling av bestillinger.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 136 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',136,'nb','Motstridende møte','Velg Ja hvis du ønsker å tillate motstridende møter i Resource Central. Ellers velger du Nei.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 137 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',137,'nb','Sorteringsrekkefølge','Velg sorteringsrekkefølge som skal brukes for å sortere ressursene i ResourceFinder')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 138 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',138,'nb','Datoskilletegn','Velg datoskilletegnet som skal brukes i valgt datoformat.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 139 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',139,'nb','Klokkeslettformat','Velg klokkeslettformatet som skal brukes i valgt datoformat.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 140 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',140,'nb','Godta agent automatisk','Dette flagget bestemmer om de motstridende tilfeller av gjentatt møte skal opprettes/oppdateres eller ikke.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 141 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',141,'nb','Enhet','Den valgte enheten vil bli brukt som måleenhet ved utskrift av navneskilt i besøksmodulen.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 142 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',142,'nb','Sperret','Hvis dette alternativet er satt til Ja, vil ansvarlige roller ikke kunne redigere verdien av denne egenskapen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 143 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',143,'nb','Åpen starttid','Starttid for åpningstider for denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 144 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',144,'nb','Åpen sluttid','Sluttid for åpningstider for denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 145 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',145,'nb','Ressurser','Velg ressurser for virtuell ressurs')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 146 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',146,'nb','Buffertid (etter)','Etterbufringstid for denne ressursen (min.)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 147 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',147,'nb','Buffertid (før)','Forhåndsbufringstid for denne ressursen (min.)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 148 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',148,'nb','Gjør ressursen usynlig','Denne egenskapen bestemmer om denne ressursen vil være synlig i ResourceFinder eller ikke')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 149 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',149,'nb','E-post','Angi e-postadressen til personen forbundet med denne oppslagsverdien')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 150 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',150,'nb','Vis reservasjon','Angi om du vil vise reservasjonsdelen i bestillingsskjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 151 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',151,'nb','Vis bestilling','Angi om du vil vise bestillingsdelen i bestillingsskjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 152 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',152,'nb','Vis deltakere','Angi om du vil vise deltakerdelen i bestillingsskjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 153 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',153,'nb','Vis egenskaper','Angi om du vil vise egenskapsdelen i bestillingsskjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 154 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',154,'nb','Frist for catering','Angi fristen (en dag før) og tidspunkt for catering')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 155 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',155,'nb','Frist for tjenester','Angi fristen (1 dag før) og tidspunkt for ekstra tjenester')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 156 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',156,'nb','Lett ressurs','Velg Ja hvis du ikke ønsker å utføre bestilingsgjennomføringen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 157 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',157,'nb','Navn','Kalendernavn')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 158 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',158,'nb','Standard','Velg Ja for å angi denne kalenderen som standard')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 159 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',159,'nb','Klassisk format','Velg om du vil at serveringer skal vises i klassisk format på bestillingsskjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 160 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',160,'nb','Språk','Velg språket som skal brukes i e-poster innenfor Resource Central')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 161 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',161,'nb','Datoformat','Velg datoformatet som skal brukes i e-post og Resource Central for denne personen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 162 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',162,'nb','Klokkeslettformat','Velg klokkeslettformatet som skal brukes i valgt datoformat.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 163 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',163,'nb','Datoskilletegn','Velg datoskilletegnet som skal brukes i valgt datoformat.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 164 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',164,'nb','Aktiveringskode','Angi aktiveringsnøkkel')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 165 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',165,'nb','Besøkende-ID','Besøkende-ID')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 166 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',166,'nb','Exchange integreringstjenesteserver','Angi navn på Exchange integreringstjenesteserver')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 167 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',167,'nb','Ekstra Id 1','Ekstra Id kan brukes til et eksternt elementnummer eller gruppenummer. Det brukes vanligvis når data blir eksportert til fakturaformål.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 168 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',168,'nb','Nåværende språk','Det nåværende skjemaspråket.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 169 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',169,'nb','Språk utfylt','Liste over språk utfylt på dette skjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 170 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',170,'nb','Valgte land','Listen over land som inngår i denne regionen.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 171 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',171,'nb','Valgte personer','Listen over personer som inngår i denne regionen.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 172 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',172,'nb','Regionnavn','Angi navn på regionen.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 173 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',173,'nb','Beskrivelse','Angi en beskrivelse av regionen.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 174 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',174,'nb','Delt bestillingsskjema','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 175 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',175,'nb','Deleger','Er delegeringsfunksjonen i bruk?')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 178 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',178,'nb','System-e-post','E-postadressen som brukes av RC når du sender ut bekreftelses-e-post fra virtuelle ressurser eller fra ressurser som er booket via felles bestillingsskjemaer.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 179 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',179,'nb','Delt bestillingsskjema','Når du bruker et skjema som et delt bestillingsskjema, kan arrangøren velge flere ressurser. Hvis alle de valgte ressursene har samme delte bestillingsskjema, vil dette bli brukt.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 180 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',180,'nb','Roller','Roller')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 181 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',181,'nb','Ekstra Id 1','Ekstra Id kan brukes til et eksternt elementnummer eller gruppenummer. Det brukes vanligvis når data blir eksportert til fakturaformål.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 182 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',182,'nb','Ekstra Id 2','Ekstra Id kan brukes til et eksternt elementnummer eller gruppenummer. Det brukes vanligvis når data blir eksportert til fakturaformål.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 183 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',183,'nb','Tillat konflikter:','Tillat konflikter i gjentatte bestillinger.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 184 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',184,'nb','SMTP-server','Angi navn eller adresse på SMTP-server.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 185 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',185,'nb','SMTP-konto','Angi navnet på kontoen med \"Send som\"-rettigheter som skal sende e-post på vegne av alle ressursene som brukes av Resource Central.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 186 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',186,'nb','SMTP-passord','Angi passord for ovennevnte konto som brukes til å sende e-post i Resource Central.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 187 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',187,'nb','SMTP-port','Angi porten du vil bruke for å sende e-post.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 188 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',188,'nb','Vis brukerbegrensninger','Denne egenskapen avgjør om brukerne vil bli vist brukerbegrensninger for bestilling av denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 190 AND [Language] = 'nb' AND ObjectName = 'InputFields')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'InputFields',190,'nb','Avdeling','Skriv Avdeling-verdien forbundet med denne oppslagsverdien')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 3 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',3,'nb','Bestillingsskjema','Bestillingsskjema')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 5 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',5,'nb','Bestillingsstatus','Bestillingsstatus')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 6 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',6,'nb','Ressurs','Ressurs')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 7 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',7,'nb','Punkter','Punkter')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 8 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',8,'nb','Egenskaper','Egenskaper')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 9 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',9,'nb','Forhåndsvisning','Forhåndsvisning')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 10 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',10,'nb','Tilbake','Tilbake')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 11 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',11,'nb','Avslutt','Avslutt')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 12 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',12,'nb','Lagre','Lagre')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 13 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',13,'nb','Ny','Ny')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 14 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',14,'nb','Slett','Slett')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 15 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',15,'nb','Skriv ut','Skriv ut')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 16 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',16,'nb','Basic','Grunnleggende parametre')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 17 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',17,'nb','Liste','Gå tilbake til listevisning')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 18 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',18,'nb','Rediger skjema','Bruk HTML-editor for å redigere dette skjemaet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 19 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',19,'nb','Roller','Roller')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 20 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',20,'nb','E-postlogg','E-postlogg')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 21 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',21,'nb','Registrere','Registrer ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 22 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',22,'nb','Avregistrer','Avregistrer ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 23 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',23,'nb','Personer','Personer')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 24 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',24,'nb','Oppgave','Vis oppgaver')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 25 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',25,'nb','Avslå','Avslå bestilling')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 26 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',26,'nb','Angi passord','Angi eller endre passord')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 27 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',27,'nb','Reservasjoner','Vis reservasjoner for ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 28 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',28,'nb','Fyldig beskrivelse','Fyldig tekstbeskrivelse (html)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 29 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',29,'nb','Lagre og lukk','Klikk her for å gå tilbake til Outlook')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 30 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',30,'nb','Kjør','Klikk her for å kjøre')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 31 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',31,'nb','Send på nytt','Send e-post på nytt')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 32 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',32,'nb','Opplasting','Last opp en lisensfil')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 33 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',33,'nb','Arrangør','SMTP-adressen til arrangøren')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 34 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',34,'nb','Legg til rolle','Legg til en rollerelasjon til denne egenskapen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 35 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',35,'nb','Egenskap','Tilbake til egenskap')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 36 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',36,'nb','Legg til','Sett inn ny')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 37 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',37,'nb','Person','Tilbake til person')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 38 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',38,'nb','Legg til element','Legg en elementrelasjon til denne rollen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 39 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',39,'nb','Rolle','Tilbake til rolle')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 40 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',40,'nb','Legg til person','Legg til en personrelasjon til denne rollen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 41 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',41,'nb','Legg til egenskap','Legg til en egenskapsrelasjon til denne rollen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 42 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',42,'nb','Forny','Oppdater siden')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 43 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',43,'nb','Slett','Slett merkede')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 44 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',44,'nb','Filter','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 45 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',45,'nb','Oppgave','Vis oppgaver')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 46 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',46,'nb','Avansert','Se det avanserte grensesnittet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 47 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',47,'nb','Opprett strekkode','Klikk for å opprette strekkoder')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 48 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',48,'nb','Bekreft','Bekreft')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 49 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',49,'nb','Element','Gå tilbake til element')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 50 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',50,'nb','Legg til valgt','Legg til den valgte ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 51 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',51,'nb','Strekkodeoppføring','Klikk for å opprette strekkode')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 52 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',52,'nb','Godta','Godta bestilling')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 53 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',53,'nb','Steder','Steder')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 54 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',54,'nb','Kjør rapport','Kjør rapport')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 55 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',55,'nb','Konfigurer','Konfigurer integrering av Exchange Server')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 56 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',56,'nb','Tilbakestill','Klikk her for å tilbakestille')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 57 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',57,'nb','Rediger navneskilt','Bruk HTML-editor for å redigere dette navneskiltet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 58 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',58,'nb','Skriv ut alle navneskilt','Klikk her for å skrive ut alle navneskilt')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 59 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',59,'nb','','Klikk her for bare å vise forventede besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 60 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',60,'nb','','Klikk her for bare å vise ankommede besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 61 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',61,'nb','','Klikk her for bare å vise avreisende besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 62 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',62,'nb','Skriv ut navneskilt','Skriver ut navneskilt for den valgte eller viste besøkende')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 63 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',63,'nb','Endre tidssone','Endre tidssonen for brukeren')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 64 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',64,'nb','Skriv ut alle','Klikk her for å skrive ut alle bestillinger')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 65 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',65,'nb','Oppdater tillatelser','Klikk her for å oppdatere tillatelser')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 66 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',66,'nb','Legg til rolle','Legg til en rollerelasjon til dette elementet')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 67 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',67,'nb','Legg til element','Legg en elementrelasjon til denne ressursen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 68 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',68,'nb','Legg til rolle','Legg til en rollerelasjon til denne personen')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 69 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',69,'nb','Oppdatere','Oppretter neste rekke forekomster som er angitt i grunnparameteren')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 70 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',70,'nb','Neste','Flytt til neste forekomst')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 71 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',71,'nb','Forrige','Flytt til forrige forekomst')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 72 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',72,'nb','Registrer alle','Registrer alle ressursene')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 73 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',73,'nb','Avregistrer alle','Avregistrer alle ressursene')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 74 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',74,'nb','Bygg opp oppgave','Bygger relasjonsoppgavebuffer')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 75 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',75,'nb','Angi standardsted','Angi standardsted (Dette vil bli vist etter at du har klikket på Outlook-knappen)')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 76 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',76,'nb','Slett bestillinger','Sletter alle bestillinger forbundet med de utvalgte møtene')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 77 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',77,'nb','Lagre konfigurasjon','Lagrer konfigurasjonen av skjermen som standard')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 78 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',78,'nb','Språk','Sett standardspråket for ResourceFinder, Mine møter, bestillingsskjemaet og alle e-poster')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1001 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1001,'nb','Temaer','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1002 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1002,'nb','Hjelp','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1003 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1003,'nb','Vis deltakere','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1004 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1004,'nb','Tidsluke','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1005 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1005,'nb','Svart','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1006 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1006,'nb','Sølv','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1007 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1007,'nb','15 minutter','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1008 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1008,'nb','30 minutter','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1009 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1009,'nb','60 minutter','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1010 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1010,'nb','Blå','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1021 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1021,'nb','Tilgjengelige ressurser','Vis tilgjengelige ressurser')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1022 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1022,'nb','Valgte ressurser','Vis valgte ressurser')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1023 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1023,'nb','Åpen','Vis oppgaver med status ny, endret eller slettet.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1024 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1024,'nb','Alle','Vis alle filtrerte oppgaver')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1025 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1025,'nb','Filtre','Klikk for å konfigurere filter')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1027 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1027,'nb','','Søk')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1028 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1028,'nb','Bekreft','Bekreft oppgaver')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1029 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1029,'nb','Bekreft alle','Bekreft alle egenskaper og møterom.')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1030 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1030,'nb','Avslå alle','Avslå alle feltene i denne oppgaven og send e-post til arrangør')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1031 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1031,'nb','Forbundne skjemaer','Forbundne skjemaer')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1032 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1032,'nb','Angi bestillingsstatus','')

SET @MaxId = (SELECT max(id) +  1 from Translations)  IF NOT EXISTS (SELECT 1 FROM Translations WHERE ObjectId = 1041 AND [Language] = 'nb' AND ObjectName = 'ToolbarFunctions')   INSERT INTO [dbo].[Translations]
([id],[ObjectName],[ObjectId],[Language],[Caption],[TooltipDescription])
VALUES
(@MaxId,'ToolbarFunctions',1041,'nb','Lagre og lukk','')
GO
exec [dbo].[spEXECsp_RECOMPILE]
GO
UPDATE [DBVersion] SET [Value] = '3.8.0004.0039' WHERE [Property]='dbVersion'
GO